/*
 * Decompiled with CFR 0.152.
 */
package co.clai.game;

import co.clai.AcpSession;
import co.clai.access.AccessibleFunctionHelper;
import co.clai.db.DatabaseConnector;
import co.clai.db.model.Banlist;
import co.clai.db.model.Server;
import co.clai.db.model.ServerSetting;
import co.clai.db.model.Storage;
import co.clai.db.model.Template;
import co.clai.game.AbstractGame;
import co.clai.game.prbf2.QueryPrbf2;
import co.clai.html.Builder;
import co.clai.html.GenericBuffer;
import co.clai.html.HtmlForm;
import co.clai.module.Query;
import co.clai.storage.AbstractStorage;
import co.clai.util.StringStringPair;
import co.clai.util.log.LoggingUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Prbf2
extends AbstractGame {
    private static final String QUERY_KEY_SERVERSETTINGS = "serversettings";
    private static final String QUERY_KEY_REALITYCONFIG_ADMIN = "realityconfig_admin";
    private static final String QUERY_KEY_MAPLIST = "maplist";
    private static final String QUERY_KEY_BANLIST = "banlist";
    private static final String QUERY_KEY_PUT_CHATLOG = "put_chatlog";
    public static final String CONFIG_KEY_IP = "ip";
    public static final String CONFIG_KEY_PORT = "port";
    public static final String CONFIG_KEY_QUERY = "query";
    private static final String CONFIG_KEY_TEMPLATE_SERVERSETTINGS = "serversettings";
    private static final String CONFIG_KEY_TEMPLATE_REALITYCONFIG_ADMIN = "template_realityconfig_admin";
    private static final String CONFIG_KEY_MAPLIST = "maplist";
    public static final String CONFIG_KEY_LOCAL_IP = "local_ip";
    public static final String CONFIG_KEY_SV_ADMIN_SCRIPT = "sv_adminScript";
    public static final String CONFIG_KEY_SV_BROWSER_NAME = "browser_name";
    public static final String CONFIG_KEY_SV_PASSWORD = "sv_password";
    public static final String CONFIG_KEY_SV_WELCOMEMESSAGE = "sv_welcomeMessage";
    public static final String CONFIG_KEY_SV_LOGO_URL = "sv_LogoURL";
    public static final String CONFIG_KEY_SV_MAX_PLAYERS = "sv_maxPlayers";
    public static final String CONFIG_KEY_ADMIN_GROUPS = "admin_groups";
    public static final String CONFIG_KEY_SMB_EXCLUDE_LIST = "smb_excludeList";
    public static final String KEY = "pfbf2";
    public static final String NAME = "Project Reality: Battlefield 2";
    private final Logger logger = LoggingUtil.getLoggerFromModule(Query.class);
    private final Map<String, String> options = Prbf2.loadOptions();

    protected Prbf2() {
        super(KEY, NAME);
    }

    private static Map<String, String> loadOptions() {
        HashMap<String, String> retMap = new HashMap<String, String>();
        retMap.put(CONFIG_KEY_IP, "IP Adress");
        retMap.put(CONFIG_KEY_PORT, "Game Port");
        retMap.put(CONFIG_KEY_QUERY, "Query Port");
        retMap.put("serversettings", "Template for serversettings.con");
        retMap.put(CONFIG_KEY_TEMPLATE_REALITYCONFIG_ADMIN, "Template for realityconfig_admin.py");
        retMap.put("maplist", "maplist.con");
        retMap.put(CONFIG_KEY_LOCAL_IP, "Local IP Adress");
        retMap.put(CONFIG_KEY_SV_ADMIN_SCRIPT, "Admin script");
        retMap.put(CONFIG_KEY_SV_BROWSER_NAME, "In Game Name");
        retMap.put(CONFIG_KEY_SV_PASSWORD, "Password");
        retMap.put(CONFIG_KEY_SV_WELCOMEMESSAGE, "Welcome message");
        retMap.put(CONFIG_KEY_SV_LOGO_URL, "logo url");
        retMap.put(CONFIG_KEY_SV_MAX_PLAYERS, "maximum player count");
        retMap.put(CONFIG_KEY_ADMIN_GROUPS, "Admin Usergroups");
        retMap.put(CONFIG_KEY_SMB_EXCLUDE_LIST, "Smartbalance excluded Clan Tags");
        return retMap;
    }

    @Override
    public List<StringStringPair> getAvailableOptions() {
        ArrayList<StringStringPair> retOptions = new ArrayList<StringStringPair>();
        for (Map.Entry<String, String> e : this.options.entrySet()) {
            retOptions.add(new StringStringPair(e.getKey(), e.getValue()));
        }
        return retOptions;
    }

    @Override
    public Builder renderOption(AcpSession s, ServerSetting setting) {
        GenericBuffer b = new GenericBuffer("");
        HtmlForm hf = new HtmlForm("editServer.editSetting", HtmlForm.Method.POST, null);
        String setKey = setting.getSettingKey();
        boolean hasDeleteButton = false;
        switch (setKey) {
            case "admin_groups": {
                hf.writeText(this.options.get(setKey) + ":");
                hf.addTextArea("data", new String(setting.getData()), 5, 15);
                hasDeleteButton = true;
                break;
            }
            case "local_ip": 
            case "sv_adminScript": 
            case "browser_name": 
            case "sv_password": 
            case "sv_welcomeMessage": 
            case "sv_LogoURL": 
            case "smb_excludeList": 
            case "sv_maxPlayers": {
                hasDeleteButton = true;
            }
            case "ip": 
            case "port": 
            case "query": {
                hf.addTextElement(this.options.get(setKey), "data", new String(setting.getData()));
                break;
            }
            case "serversettings": 
            case "template_realityconfig_admin": 
            case "maplist": {
                hf.addSelectionDropdown(this.options.get(setKey), "data", Template.getAccessibleTemplates(new AccessibleFunctionHelper("editServer", "editSetting"), s.getDbCon(), s.getThisUser()), new String(setting.getData()));
                break;
            }
            default: {
                hf.addTextElement("Unknown option " + setKey, "data", new String(setting.getData()));
            }
        }
        hf.addHiddenElement("id", setting.getId() + "");
        hf.addSubmit("Change Value", HtmlForm.ButtonType.WARNING);
        b.write(hf);
        if (hasDeleteButton) {
            HtmlForm deleteButtonF = new HtmlForm("editServer.removeSetting", HtmlForm.Method.POST, null);
            deleteButtonF.addHiddenElement("id", setting.getId() + "");
            deleteButtonF.addSubmit("Delete Setting", HtmlForm.ButtonType.DANGER);
            b.write(deleteButtonF);
        }
        return b;
    }

    @Override
    public List<StringStringPair> getAvailableQueries() {
        ArrayList<StringStringPair> retOptions = new ArrayList<StringStringPair>();
        retOptions.addAll(Arrays.asList(new StringStringPair(QUERY_KEY_REALITYCONFIG_ADMIN, "realityconfig_admin.py file"), new StringStringPair("serversettings", "serversettings.con file"), new StringStringPair("maplist", "maplist.con file"), new StringStringPair(QUERY_KEY_BANLIST, "banlist.con file"), new StringStringPair(QUERY_KEY_PUT_CHATLOG, "puts a chatlog into storage")));
        return retOptions;
    }

    @Override
    public String executeQuery(DatabaseConnector dbCon, String command, Server server, Map<String, String[]> parameters, AcpSession session) {
        switch (command) {
            case "serversettings": {
                ServerSetting setting = ServerSetting.getServerSettingByServerIdAndKey(dbCon, server.getId(), "serversettings");
                if (setting == null) {
                    return "";
                }
                StringBuilder sb = new StringBuilder(new String(Template.getTemplateByKey(dbCon, new String(setting.getData())).getData()));
                QueryPrbf2.appendServerSettings(dbCon, sb, server);
                return sb.toString();
            }
            case "realityconfig_admin": {
                ServerSetting setting = ServerSetting.getServerSettingByServerIdAndKey(dbCon, server.getId(), CONFIG_KEY_TEMPLATE_REALITYCONFIG_ADMIN);
                if (setting == null) {
                    return "";
                }
                StringBuilder sb = new StringBuilder(new String(Template.getTemplateByKey(dbCon, new String(setting.getData())).getData()));
                QueryPrbf2.appendAdminHashes(dbCon, sb, server);
                return sb.toString();
            }
            case "maplist": {
                ServerSetting setting = ServerSetting.getServerSettingByServerIdAndKey(dbCon, server.getId(), "maplist");
                if (setting == null) {
                    return "";
                }
                return new String(Template.getTemplateByKey(dbCon, new String(setting.getData())).getData());
            }
            case "banlist": {
                List<Integer> banlistIds = server.getBanlistIds();
                HashSet<String> bannedHashes = new HashSet<String>();
                for (Integer n : banlistIds) {
                    Banlist list = Banlist.getBanlistById(dbCon, n);
                    if (list.getCommunityId() != server.getCommunityId()) {
                        this.logger.log(Level.WARNING, "server with id " + server.getId() + " trying to pull bans from other community; banlist id: " + list.getId());
                        continue;
                    }
                    bannedHashes.addAll(list.getActiveBans(dbCon));
                }
                StringBuilder sb = new StringBuilder();
                for (String s : bannedHashes) {
                    sb.append("admin.addKeyToBanList " + s + " Perm\n");
                }
                return sb.toString();
            }
            case "put_chatlog": {
                try {
                    Storage stor = Storage.getStorageByKey(dbCon, parameters.get("storage_id")[0]);
                    AbstractStorage absStor = AbstractStorage.getRemoteFromLocation(stor);
                    String identifier = parameters.get("identifier")[0];
                    StringBuilder stringBuilder = new StringBuilder();
                    String[] chatlog = new String(absStor.getData(identifier)).split("\n");
                    stringBuilder.append(chatlog[0].substring(15) + " ");
                    stringBuilder.append(chatlog[1].substring(15) + " ");
                    stringBuilder.append(chatlog[2].substring(15));
                    ArrayList<SimpleDateFormat> dateFormList = new ArrayList<SimpleDateFormat>();
                    dateFormList.add(new SimpleDateFormat("yyyy-mm-dd kk:mm"));
                    dateFormList.add(new SimpleDateFormat("yyyymmdd kk:mm"));
                    String timeString = chatlog[5].substring(15);
                    long timestamp = -1L;
                    for (SimpleDateFormat f : dateFormList) {
                        try {
                            timestamp = f.parse(timeString).getTime();
                        }
                        catch (Exception e) {
                            System.out.println("tried parsing: " + e.getMessage());
                        }
                    }
                    absStor.pushIndex(dbCon, identifier, stringBuilder.toString(), timestamp, session.getClientIp());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return "error: " + e.getMessage();
                }
                return "success";
            }
        }
        this.logger.log(Level.WARNING, "Unknown query command '" + command + "'!");
        return "";
    }

    @Override
    public String getDefaultOption(String settingKey) {
        switch (settingKey) {
            case "admin_groups": {
                return "[\n{\n    \"location\" : \"<location id>\",\n    \"field_id\" : \"<field id>\",\n    \"groups\" : [\n        {\n            \"role\" : \"<role 1>\",\n            \"groups\" : \"<groups 1>\"\n        },\n        {\n            \"role\" : \"<role 2>\",\n            \"groups\" : \"<groups 2>\"\n        }\n}\n]";
            }
            case "sv_adminScript": {
                return "prism";
            }
            case "port": {
                return "16567";
            }
            case "query": {
                return "29900";
            }
            case "smb_excludeList": {
                return "[\"[R-DEV]*\",\"[R-CON]*\"]";
            }
            case "sv_maxPlayers": {
                return "100";
            }
        }
        return "";
    }
}

