/*
 * Decompiled with CFR 0.152.
 */
package co.clai.html;

import co.clai.AcpSession;
import co.clai.db.DatabaseConnector;
import co.clai.db.model.Community;
import co.clai.db.model.User;
import co.clai.html.Builder;
import co.clai.html.Menu;
import co.clai.util.RandomUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;

public class HtmlPage
implements Builder {
    private final StringBuilder sb = new StringBuilder();
    private static final String PAGE_HTML_RESOURCE_NAME = "/html/page.html";
    private static List<String> partsEndMarker = HtmlPage.loadPartsEndMarker();
    private static List<String> partsContent = HtmlPage.loadPartsContent(partsEndMarker);
    private final String footer;
    private final AcpSession session;
    private final DatabaseConnector dbCon;

    public HtmlPage(DatabaseConnector dbCon, String title, String script, String style, String footer, AcpSession session) {
        this.session = session;
        this.dbCon = dbCon;
        this.write(partsContent.get(0));
        this.write(Builder.escapeForHtml(title));
        this.write(partsContent.get(1));
        this.write(script == null ? "" : script);
        this.write(partsContent.get(2));
        this.write(style == null ? "" : style);
        this.write(partsContent.get(3));
        this.write("\n<nav class='navbar navbar-expand-md navbar-light bg-light rounded'>\n<a class='navbar-brand visible-md' href='#'>Menu</a>\n<button class='navbar-toggler' type='button' data-toggle='collapse'  data-target='#navbarsExample04' aria-controls='navbarsExample04'  aria-expanded='false' aria-label='Toggle navigation'>\n<span class='navbar-toggler-icon'></span>\n </button> <div class='collapse navbar-collapse' id='navbarsExample04'>");
        User thisUser = session.getThisUser();
        if (thisUser == null) {
            this.write("<ul class='navbar-nav mr-auto navbar-right'>");
            this.write("<li class='nav-item'><a class='nav-link' href='index'>Login</a>\n</li>");
            this.write("</ul>");
        } else {
            this.write("<ul class='navbar-nav mr-auto'>");
            for (Menu.MenuEntry m : Menu.loadMenuData(thisUser)) {
                this.write(HtmlPage.renderSubMenu(m));
            }
            this.write("</ul>");
            this.write("<ul class='nav navbar-nav navbar-right'>");
            this.write(HtmlPage.renderSubMenu(Menu.loadUserMenuData(thisUser.getUsername())));
            this.write("</ul>");
        }
        this.write("\n</div></nav><br/>");
        this.write(partsContent.get(4));
        this.footer = Builder.escapeForHtml(footer);
    }

    private static String renderSubMenu(Menu.MenuEntry menuData) {
        StringBuilder stream = new StringBuilder();
        if (menuData.subMenu == null) {
            stream.append("<li class='nav-item'><a class='nav-link' a href='" + menuData.url + "'>" + Builder.escapeForHtml(menuData.name) + "</a></li>\n");
        } else {
            String id = "aria_id_" + RandomUtil.getRandomString(30);
            stream.append("<li class='nav-item dropdown'>");
            stream.append("<a class='nav-link dropdown-toggle' href='#' id='" + id + "' data-toggle='dropdown' aria-haspopup='true' aria-expanded='false'>" + Builder.escapeForHtml(menuData.name) + "</a>");
            stream.append("<div class='dropdown-menu' aria-labelledby='" + id + "'>");
            for (Menu.MenuEntry m : menuData.subMenu) {
                stream.append("<a class='dropdown-item' href='" + m.url + "'>" + Builder.escapeForHtml(m.name) + "</a>\n");
            }
            stream.append("</div></li>");
        }
        return stream.toString();
    }

    private static List<String> loadPartsEndMarker() {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add("TITLE");
        retList.add("SCRIPT");
        retList.add("STYLE");
        retList.add("MENU");
        retList.add("CONTENT");
        retList.add("FOOTER");
        return retList;
    }

    private static List<String> loadPartsContent(List<String> endMarkerList) {
        ArrayList<String> retList = new ArrayList<String>();
        try (BufferedReader b = new BufferedReader(new InputStreamReader(endMarkerList.getClass().getResourceAsStream(PAGE_HTML_RESOURCE_NAME)));){
            for (String s : endMarkerList) {
                String tmp;
                StringBuilder sb = new StringBuilder();
                while (b.ready() && !(tmp = b.readLine()).contains("-- " + s + " --")) {
                    sb.append(tmp + "\n");
                }
                retList.add(sb.toString());
            }
            StringBuilder sb = new StringBuilder();
            while (b.ready()) {
                String tmp = b.readLine();
                sb.append(tmp + "\n");
            }
            retList.add(sb.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return retList;
    }

    private void write(String html) {
        this.sb.append(html + "\n");
    }

    @Override
    public void writeWithoutEscaping(String html) {
        this.write(html);
    }

    @Override
    public String finish() {
        this.sb.append(partsContent.get(5));
        User thisUser = this.session.getThisUser();
        int communityId = thisUser == null ? 0 : thisUser.getCommunityId();
        this.sb.append(this.footer == null ? "Powered by <a href=\"https://github.com/ClundXIII/acp-java\">acp-java</a>, hosted by " + Community.getCommunityById(this.dbCon, communityId).getName() : this.footer);
        this.sb.append(partsContent.get(6));
        return this.sb.toString();
    }

    public static String getMessage(Map<String, String[]> parameters) {
        String[] messageParams = parameters.get("message");
        if (messageParams == null || messageParams.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<div id=\"function_return_message\">");
        sb.append(Builder.escapeForHtml(messageParams[0]));
        sb.append("</div>");
        return sb.toString();
    }

    public void writeH1(String string) {
        this.write("<h1>" + Builder.escapeForHtml(string) + "</h1>");
    }

    public void writeH2(String string) {
        this.write("<h2>" + Builder.escapeForHtml(string) + "</h2>");
    }

    public void writeH3(String string) {
        this.write("<h3>" + Builder.escapeForHtml(string) + "</h3>");
    }

    public void writeText(String string) {
        this.write(Builder.escapeForHtml(string));
    }

    @Override
    public void write(Builder b) {
        this.write(b.finish());
    }

    public void writeLink(String location, String text) {
        this.write("<a href='" + location + "'>" + Builder.escapeForHtml(text) + "</a>");
    }

    public void writeLink(URIBuilder location, String text) {
        this.writeLink(location.toString(), text);
    }

    public void writeHline() {
        this.write("<hr>");
    }

    public void writePre(String string) {
        this.write("<pre>" + Builder.escapeForHtml(string) + "</pre>");
    }
}

