/*
 * Decompiled with CFR 0.152.
 */
package co.clai.remote;

import co.clai.db.DatabaseConnector;
import co.clai.db.model.Location;
import co.clai.db.model.User;
import co.clai.remote.AbstractRemoteConnection;
import co.clai.remote.OAuth2Helper;
import co.clai.remote.RemoteUserData;
import co.clai.util.RandomUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mindrot.jbcrypt.BCrypt;

public class DummyConnection
extends AbstractRemoteConnection {
    public static final String CONNECTION_TYPE = "remoteDummy";
    public static final String JSON_KEY_USERGROUPS = "usergroups";
    private static final String JSON_KEY_PASSWORD = "password";
    private static final String JSON_KEY_USER_NAME_ID_MAP = "userNameIdMap";
    private static final String JSON_KEY_EMAIL = "email";
    private static final String JSON_KEY_USERNAME = "username";
    private static final String JSON_KEY_USER_ID = "userId";
    private static final String JSON_KEY_USER = "user";
    private final JSONObject data;

    public DummyConnection(JSONObject data) {
        this.data = data;
    }

    public DummyConnection(Location l) {
        JSONObject tmpData = l == null ? null : l.getConfig();
        this.data = tmpData;
    }

    @Override
    protected String getRemoteTypeName() {
        return CONNECTION_TYPE;
    }

    @Override
    public RemoteUserData getUserDataByUserId(int userId) {
        JSONObject userJSON = this.data.getJSONObject(JSON_KEY_USER).getJSONObject(userId + "");
        List<Integer> userGroups = this.getUsergroupsFromUserId(userId);
        return new RemoteUserData(Integer.parseInt(userJSON.getString(JSON_KEY_USER_ID)), userJSON.getString(JSON_KEY_USERNAME), userGroups, userJSON.getString(JSON_KEY_EMAIL));
    }

    @Override
    public RemoteUserData getUserDataByUserName(String userName) {
        int userid = Integer.parseInt(this.data.getJSONObject(JSON_KEY_USER_NAME_ID_MAP).getString(userName));
        return this.getUserDataByUserId(userid);
    }

    @Override
    public int loginUser(String username, String password) {
        int userId = Integer.parseInt(this.data.getJSONObject(JSON_KEY_USER_NAME_ID_MAP).getString(username));
        JSONObject userJSON = this.data.getJSONObject(JSON_KEY_USER).getJSONObject(userId + "");
        if (BCrypt.checkpw((String)password, (String)userJSON.getString(JSON_KEY_PASSWORD))) {
            return Integer.parseInt(userJSON.getString(JSON_KEY_USER_ID));
        }
        return -1;
    }

    @Override
    public List<Integer> getUsergroupsFromUserId(int id) {
        JSONObject userJSON = this.data.getJSONObject(JSON_KEY_USER).getJSONObject(id + "");
        ArrayList<Integer> retList = new ArrayList<Integer>();
        JSONArray uGroups = userJSON.getJSONArray(JSON_KEY_USERGROUPS);
        for (int i = 0; i < uGroups.length(); ++i) {
            retList.add(new Integer(Integer.parseInt(uGroups.getString(i))));
        }
        return retList;
    }

    @Override
    public String getUsergroupNameById(int userGroupId) {
        return this.data.getJSONObject(JSON_KEY_USERGROUPS).getString(userGroupId + "");
    }

    @Override
    public JSONObject getDefaultConfig() {
        return DummyConnection.getPlainDataObject();
    }

    public static JSONObject getPlainDataObject() {
        JSONObject retObj = new JSONObject();
        retObj.put("uniqueId", (Object)RandomUtil.getRandomString());
        retObj.put(JSON_KEY_USER, (Object)new JSONObject());
        retObj.put(JSON_KEY_USER_NAME_ID_MAP, (Object)new JSONObject());
        retObj.put(JSON_KEY_USERGROUPS, (Object)new JSONObject());
        retObj.put("type", (Object)CONNECTION_TYPE);
        return retObj;
    }

    public static void addUser(JSONObject jData, int id, String name, String password, List<Integer> userGroups, String email) {
        JSONObject newUser = new JSONObject();
        newUser.put(JSON_KEY_USER_ID, (Object)(id + ""));
        newUser.put(JSON_KEY_USERNAME, (Object)name);
        newUser.put(JSON_KEY_EMAIL, (Object)email);
        newUser.put(JSON_KEY_PASSWORD, (Object)BCrypt.hashpw((String)password, (String)BCrypt.gensalt()));
        JSONArray usergroupJA = new JSONArray();
        for (Integer i : userGroups) {
            usergroupJA.put((Object)(i + ""));
        }
        newUser.put(JSON_KEY_USERGROUPS, (Object)usergroupJA);
        jData.getJSONObject(JSON_KEY_USER).put(id + "", (Object)newUser);
        jData.getJSONObject(JSON_KEY_USER_NAME_ID_MAP).put(name, (Object)(id + ""));
    }

    public static void addUserGroup(JSONObject jData, int id, String userGroupName) {
        if (!jData.has(JSON_KEY_USERGROUPS)) {
            jData.put(JSON_KEY_USERGROUPS, (Object)new JSONObject());
        }
        jData.getJSONObject(JSON_KEY_USERGROUPS).put(id + "", (Object)userGroupName);
    }

    @Override
    public JSONObject getConfig() {
        return new JSONObject(this.data.toString());
    }

    @Override
    public boolean canDoPasswordLogin() {
        return true;
    }

    @Override
    public boolean canDoOAuth2Login() {
        return false;
    }

    @Override
    public OAuth2Helper.OAuth2Data getOAuth2Data() {
        return null;
    }

    @Override
    public User getUserWithOAuth2Code(DatabaseConnector dbCon, Map<String, String[]> parameters, int locationId) {
        return null;
    }

    @Override
    public RemoteUserData getUserDataByUserEmail(String userEmail) {
        return null;
    }

    @Override
    public List<Integer> getUserIdsFromUserGroup(int userGroupId) {
        return new ArrayList<Integer>();
    }

    @Override
    public String getUserFieldContentFromUserId(String fieldId, int userId) {
        return "";
    }
}

