/*
 * Decompiled with CFR 0.152.
 */
package co.clai.util;

import com.amazonaws.util.IOUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.StringJoiner;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.client.utils.URIBuilder;

public class HttpRequestUtil {
    public static String httpRequest(String url) {
        return HttpRequestUtil.httpRequest(url, null);
    }

    public static String httpRequest(String queryScriptLocation, Map<String, String> parameter) {
        URLConnection testCon = null;
        try {
            URIBuilder builder = new URIBuilder(queryScriptLocation);
            if (parameter != null) {
                for (Map.Entry<String, String> s : parameter.entrySet()) {
                    builder.addParameter(s.getKey(), s.getValue());
                }
            }
            URL testUrl = new URL(builder.toString());
            testCon = testUrl.openConnection();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        StringBuilder sb = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(testCon.getInputStream()));){
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                sb.append(inputLine + "\n");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    public static String httpPostRequestAsString(String queryScriptLocation, Map<String, String> parameter) throws Exception {
        return new String(HttpRequestUtil.httpPostRequest(queryScriptLocation, parameter));
    }

    public static byte[] httpPostRequest(String queryScriptLocation, Map<String, String> parameter) throws Exception {
        return HttpRequestUtil.httpPostRequest(queryScriptLocation, parameter, null, null);
    }

    public static byte[] httpPostRequest(String queryScriptLocation, Map<String, String> parameter, String username, String password) throws Exception {
        StringJoiner sj = new StringJoiner("&");
        for (Map.Entry<String, String> entry : parameter.entrySet()) {
            sj.add(URLEncoder.encode(entry.getKey(), "UTF-8") + "=" + URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        byte[] out = sj.toString().getBytes(StandardCharsets.UTF_8);
        int length = out.length;
        URL url = new URL(queryScriptLocation);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (username != null) {
            String userpass = username + ":" + password;
            String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])userpass.getBytes());
            conn.setRequestProperty("Authorization", basicAuth);
        }
        conn.setDoOutput(true);
        conn.setInstanceFollowRedirects(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("charset", "utf-8");
        conn.setRequestProperty("Content-Length", Integer.toString(length));
        conn.setUseCaches(false);
        try (DataOutputStream wr = new DataOutputStream(conn.getOutputStream());){
            wr.write(out);
        }
        var10_11 = null;
        try (InputStream inStr = conn.getInputStream();){
            byte[] byArray = IOUtils.toByteArray((InputStream)inStr);
            return byArray;
        }
        catch (Throwable throwable) {
            var10_11 = throwable;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] httpGetRequest(String url, Map<String, String> parameter, String username, String password) {
        try {
            URIBuilder builder = new URIBuilder(url);
            if (parameter != null) {
                for (Map.Entry<String, String> s : parameter.entrySet()) {
                    builder.addParameter(s.getKey(), s.getValue());
                }
            }
            HttpURLConnection conn = (HttpURLConnection)new URL(builder.toString()).openConnection();
            conn.setDoOutput(true);
            conn.setInstanceFollowRedirects(false);
            conn.setRequestMethod("GET");
            if (username != null) {
                String userpass = username + ":" + password;
                String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])userpass.getBytes());
                conn.setRequestProperty("Authorization", basicAuth);
            }
            try (InputStream inStr = conn.getInputStream();){
                byte[] byArray = IOUtils.toByteArray((InputStream)inStr);
                return byArray;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

