/*
 * Decompiled with CFR 0.152.
 */
package co.clai.db;

import co.clai.db.DatabaseConnector;
import co.clai.db.model.AbstractDbTable;
import co.clai.util.log.LoggingUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class DbUtil {
    private static final Logger logger = LoggingUtil.getDefaultLogger();

    public static Set<Class<? extends AbstractDbTable>> getTableClasses() {
        Reflections reflections = new Reflections("co.clai.db.model", new Scanner[0]);
        return reflections.getSubTypesOf(AbstractDbTable.class);
    }

    public static List<AbstractDbTable> getTableSet() {
        Set<Class<? extends AbstractDbTable>> allClasses = DbUtil.getTableClasses();
        ArrayList<AbstractDbTable> retList = new ArrayList<AbstractDbTable>();
        for (Class<? extends AbstractDbTable> c : allClasses) {
            try {
                logger.log(Level.INFO, "instanciating " + c.getName());
                retList.add(c.newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return retList;
    }

    public static void createAllTables(DatabaseConnector dbCon) {
        List<AbstractDbTable> tables = DbUtil.getTableSet();
        for (AbstractDbTable t : tables) {
            logger.log(Level.INFO, "creating table " + t.getTableName());
            AbstractDbTable.createTable(dbCon, t);
        }
    }
}

