/*
 * Decompiled with CFR 0.152.
 */
package co.clai.module;

import co.clai.AcpSession;
import co.clai.access.AccessibleHelper;
import co.clai.access.AccessibleModuleHelper;
import co.clai.db.DatabaseConnector;
import co.clai.module.FunctionResult;
import co.clai.util.log.LoggingUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.utils.URIBuilder;
import org.json.JSONObject;

public abstract class AbstractModule {
    protected final String MESSAGE_GET_VAR = "message";
    protected final String name;
    protected final DatabaseConnector dbCon;
    protected final Logger logger;
    protected final Logger userLog;
    private final AccessibleHelper accessibleHelper;
    protected final Map<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>> functionMap = this.loadFunctions();

    public AbstractModule(String name, DatabaseConnector dbCon) {
        this(name, dbCon, new AccessibleModuleHelper(name));
    }

    public AbstractModule(String name, DatabaseConnector dbCon, AccessibleHelper accessibleHelper) {
        this.accessibleHelper = accessibleHelper;
        this.name = name;
        this.dbCon = dbCon;
        this.logger = LoggingUtil.getLoggerFromModule(this.getClass());
        this.userLog = LoggingUtil.getUserLogFromModule(this.getClass());
    }

    public String getModuleName() {
        return this.name;
    }

    public final byte[] invoke(HttpServletResponse response, AcpSession s, String function, Map<String, String[]> parameters) {
        try {
            if (function == null || function.equals("")) {
                return this.invokePlain(s, parameters);
            }
            StringBuilder logEntry = new StringBuilder();
            if (s.getThisUser() != null) {
                logEntry.append(s.getThisUser().getLocationId() + ":" + s.getThisUser().getId() + ":" + s.getThisUser().getUsername() + ": ");
            } else {
                logEntry.append("-1:-1:Unknown: ");
            }
            logEntry.append(this.getModuleName() + "." + function + " ");
            JSONObject logData = new JSONObject();
            for (Map.Entry<String, String[]> e : parameters.entrySet()) {
                if (e.getKey().contains("password")) {
                    logData.put(e.getKey(), "*");
                    continue;
                }
                logData.put(e.getKey(), e.getValue()[0]);
            }
            logEntry.append(logData.toString());
            this.userLog.log(Level.INFO, logEntry.toString());
            BiFunction<AcpSession, Map<String, String[]>, FunctionResult> f = this.functionMap.get(function);
            if (f == null) {
                return FunctionResult.Status.NOT_FOUND.name().getBytes();
            }
            FunctionResult r = f.apply(s, parameters);
            URIBuilder b = r.getBuilder();
            if (r.getStatus() != FunctionResult.Status.NONE) {
                b.addParameter("message", r.getMessage());
            }
            if (response != null) {
                response.addHeader("Location", b.build().toString());
                response.setStatus(302);
            }
            return r.getStatus().name().getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage().getBytes();
        }
    }

    protected abstract byte[] invokePlain(AcpSession var1, Map<String, String[]> var2);

    protected abstract Map<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>> loadFunctions();

    public List<String> getFunctionList() {
        if (this.functionMap == null) {
            throw new RuntimeException("functionMap from " + this.getModuleName() + " has function Map null");
        }
        ArrayList<String> retList = new ArrayList<String>();
        for (String s : this.functionMap.keySet()) {
            retList.add(s);
        }
        return retList;
    }

    public AccessibleHelper getAccessibleHelper() {
        return this.accessibleHelper;
    }
}

