/*
 * Decompiled with CFR 0.152.
 */
package co.clai.module;

import co.clai.AcpSession;
import co.clai.access.AccessibleFunctionHelper;
import co.clai.access.CommunityAsset;
import co.clai.db.DatabaseConnector;
import co.clai.db.model.Community;
import co.clai.db.model.User;
import co.clai.db.model.UserAccessFilter;
import co.clai.html.HtmlForm;
import co.clai.html.HtmlPage;
import co.clai.html.HtmlTable;
import co.clai.module.AbstractModule;
import co.clai.module.FunctionResult;
import co.clai.util.IntStringPair;
import co.clai.util.ValueValuePair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public class EditUser
extends AbstractModule {
    public static final String LOCATION = "editUser";
    private static final String GET_PARAM = "edit";
    public static final String FUNCTION_NAME_CREATE_USER = "createUser";
    public static final String FUNCTION_NAME_CHANGE_USERNAME = "changeUsername";
    public static final String FUNCTION_NAME_SET_PASSWORD = "setPassword";
    public static final String FUNCTION_NAME_CHANGE_COMMUNITY_ID = "changeCommunityId";
    public static final String FUNCTION_NAME_DELETE_USER = "deleteUser";

    public EditUser(DatabaseConnector dbCon) {
        super(LOCATION, dbCon);
    }

    @Override
    protected byte[] invokePlain(AcpSession s, Map<String, String[]> parameters) {
        HtmlPage p = new HtmlPage(this.dbCon, "Edit User", null, null, null, s);
        p.writeWithoutEscaping(HtmlPage.getMessage(parameters));
        ArrayList<ValueValuePair> selectionCommunityValues = new ArrayList<ValueValuePair>();
        if (s.getThisUser().getIsRoot()) {
            selectionCommunityValues.add(new IntStringPair(0, "Community Wide"));
        }
        for (Community c : Community.getAllCommunity(this.dbCon)) {
            if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_CREATE_USER), new CommunityAsset(c.getId()))) continue;
            selectionCommunityValues.add(new IntStringPair(c.getId(), c.getName()));
        }
        if (parameters.get(GET_PARAM) == null || parameters.get(GET_PARAM).length == 0) {
            p.writeH1("Edit User");
            HtmlTable t = new HtmlTable();
            t.addHeader(Arrays.asList("id", "name", "Community", "isRoot", "Edit"));
            t.startBody();
            List<User> allUser = User.getAllLocalUser(this.dbCon);
            User thisUser = s.getThisUser();
            for (User u : allUser) {
                if (!thisUser.hasAccess(this.getAccessibleHelper(), new CommunityAsset(u.getCommunityId()))) continue;
                HtmlTable.HtmlTableRow row = new HtmlTable.HtmlTableRow(t);
                row.writeText(u.getId() + "");
                row.writeText(u.getUsername() + "");
                row.writeText(Community.getCommunityById(this.dbCon, u.getCommunityId()).getName());
                row.writeText(u.getIsRoot() + "");
                HtmlForm fb = new HtmlForm(LOCATION, HtmlForm.Method.GET);
                fb.addHiddenElement(GET_PARAM, "true");
                fb.addHiddenElement("id", u.getId() + "");
                fb.addSubmit("Edit User", HtmlForm.ButtonType.WARNING);
                row.write(fb);
                HtmlForm editUAccessF = new HtmlForm("editUserAccess", HtmlForm.Method.GET);
                editUAccessF.addHiddenElement(GET_PARAM, "user_access");
                editUAccessF.addHiddenElement(UserAccessFilter.DB_TABLE_COLUMN_NAME_USER_ID, u.getId() + "");
                editUAccessF.addHiddenElement(UserAccessFilter.DB_TABLE_COLUMN_NAME_LOCATION_ID, "0");
                editUAccessF.addSubmit("Edit Access", HtmlForm.ButtonType.WARNING);
                row.write(editUAccessF);
                t.write(row);
            }
            p.write(t);
            if (s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_CREATE_USER))) {
                p.writeH1("Add new User");
                HtmlForm addCommFr = new HtmlForm("editUser.createUser", HtmlForm.Method.POST);
                addCommFr.addTextElement("Name", "username", "");
                addCommFr.addTextElement("Password", "password", "");
                addCommFr.addSelectionDropdown("Community Id", "community_id", selectionCommunityValues);
                addCommFr.addSubmit("Add new User", HtmlForm.ButtonType.SUCCESS);
                p.write(addCommFr);
            }
        } else {
            User u = User.getUserByLocationId(this.dbCon, 0, Integer.parseInt(parameters.get("id")[0]));
            if (!s.getThisUser().hasAccess(this.getAccessibleHelper(), new CommunityAsset(u.getCommunityId()))) {
                return (p.finish() + "no access").getBytes();
            }
            p.writeH1("Edit User " + u.getUsername());
            p.writeHline();
            p.writeH2("Edit Username");
            HtmlForm editNameR = new HtmlForm("editUser.changeUsername", HtmlForm.Method.POST);
            editNameR.addTextElement("new Username", "username", u.getUsername());
            editNameR.addHiddenElement("id", u.getId() + "");
            editNameR.addSubmit("Change Username", HtmlForm.ButtonType.WARNING);
            p.write(editNameR);
            p.writeHline();
            p.writeH2("Set New Password");
            HtmlForm setNewPaswdR = new HtmlForm("editUser.setPassword", HtmlForm.Method.POST);
            setNewPaswdR.addPasswordElement("New Password", "password");
            setNewPaswdR.addHiddenElement("id", u.getId() + "");
            setNewPaswdR.addSubmit("Set new Password", HtmlForm.ButtonType.WARNING);
            p.write(setNewPaswdR);
            p.writeHline();
            p.writeH2("Change Community Id");
            HtmlForm changeCommunityIdR = new HtmlForm("editUser.changeCommunityId", HtmlForm.Method.POST);
            changeCommunityIdR.addSelectionDropdown("new Community Id", "community_id", selectionCommunityValues, u.getCommunityId() + "");
            changeCommunityIdR.addHiddenElement("id", u.getId() + "");
            changeCommunityIdR.addSubmit("Change Community", HtmlForm.ButtonType.WARNING);
            p.write(changeCommunityIdR);
            p.writeHline();
            p.writeH2("Delete User");
            HtmlForm deleteUserR = new HtmlForm("editUser.deleteUser", HtmlForm.Method.POST);
            deleteUserR.addHiddenElement("id", u.getId() + "");
            deleteUserR.addSubmit("Delete User", HtmlForm.ButtonType.DANGER);
            p.write(deleteUserR);
        }
        return p.finish().getBytes();
    }

    @Override
    protected Map<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>> loadFunctions() {
        HashMap<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>> retMap = new HashMap<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>>();
        retMap.put(FUNCTION_NAME_CREATE_USER, this::createUser);
        retMap.put(FUNCTION_NAME_CHANGE_USERNAME, this::changeUsername);
        retMap.put(FUNCTION_NAME_SET_PASSWORD, this::setPassword);
        retMap.put(FUNCTION_NAME_CHANGE_COMMUNITY_ID, this::changeCommunityId);
        retMap.put(FUNCTION_NAME_DELETE_USER, this::deleteUser);
        return retMap;
    }

    private FunctionResult createUser(AcpSession s, Map<String, String[]> parameter) {
        String username = parameter.get("username")[0];
        String password = parameter.get("password")[0];
        int communityId = Integer.parseInt(parameter.get("community_id")[0]);
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_CREATE_USER), new CommunityAsset(communityId))) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, LOCATION);
        }
        User.addNewLocalUser(this.dbCon, username, password, communityId, false);
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, LOCATION);
        r.getBuilder().addParameter("id", User.getUserByLocationName(this.dbCon, 0, username).getId() + "");
        r.getBuilder().addParameter(GET_PARAM, "true");
        return r;
    }

    private FunctionResult changeUsername(AcpSession s, Map<String, String[]> parameter) {
        int userId = Integer.parseInt(parameter.get("id")[0]);
        String newUsername = parameter.get("username")[0];
        User u = User.getUserByLocationId(this.dbCon, 0, userId);
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_CHANGE_USERNAME), new CommunityAsset(u.getCommunityId()))) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, LOCATION);
        }
        u.setNewUsername(this.dbCon, newUsername);
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, LOCATION);
        r.getBuilder().addParameter("id", u.getId() + "");
        r.getBuilder().addParameter(GET_PARAM, "true");
        return r;
    }

    private FunctionResult setPassword(AcpSession s, Map<String, String[]> parameter) {
        int userId = Integer.parseInt(parameter.get("id")[0]);
        String newPassword = parameter.get("password")[0];
        User u = User.getUserByLocationId(this.dbCon, 0, userId);
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_SET_PASSWORD), new CommunityAsset(u.getCommunityId()))) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, LOCATION);
        }
        u.setNewPassword(this.dbCon, newPassword);
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, LOCATION);
        r.getBuilder().addParameter("id", u.getId() + "");
        r.getBuilder().addParameter(GET_PARAM, "true");
        return r;
    }

    private FunctionResult changeCommunityId(AcpSession s, Map<String, String[]> parameter) {
        int userId = Integer.parseInt(parameter.get("id")[0]);
        int newCommId = Integer.parseInt(parameter.get("community_id")[0]);
        User u = User.getUserByLocationId(this.dbCon, 0, userId);
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_CHANGE_COMMUNITY_ID), new CommunityAsset(u.getCommunityId()))) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, LOCATION);
        }
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_CHANGE_COMMUNITY_ID), new CommunityAsset(newCommId))) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, LOCATION);
        }
        u.setNewCommunityId(this.dbCon, newCommId);
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, LOCATION);
        r.getBuilder().addParameter("id", u.getId() + "");
        r.getBuilder().addParameter(GET_PARAM, "true");
        return r;
    }

    private FunctionResult deleteUser(AcpSession s, Map<String, String[]> parameter) {
        int userId = Integer.parseInt(parameter.get("id")[0]);
        User u = User.getUserByLocationId(this.dbCon, 0, userId);
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_CHANGE_COMMUNITY_ID), new CommunityAsset(u.getCommunityId()))) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, LOCATION);
        }
        u.deleteUser(this.dbCon);
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, LOCATION);
        return r;
    }
}

