/*
 * Decompiled with CFR 0.152.
 */
package co.clai.module;

import co.clai.db.DatabaseConnector;
import co.clai.module.AbstractModule;
import co.clai.util.log.LoggingUtil;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ModuleUtil {
    private static final Map<String, List<String>> moduleFunctionMap = ModuleUtil.loadModuleFunctionMap();
    private static final List<String> functionList = ModuleUtil.loadFunctionList(moduleFunctionMap);
    private static final Set<Class<? extends AbstractModule>> moduleList = ModuleUtil.loadModuleClasses();

    private static Set<Class<? extends AbstractModule>> loadModuleClasses() {
        Reflections reflections = new Reflections("co.clai.module", new Scanner[0]);
        Set retSet = reflections.getSubTypesOf(AbstractModule.class);
        for (Class c : retSet) {
            LoggingUtil.createLoggerForModule(c);
        }
        return retSet;
    }

    public static Set<Class<? extends AbstractModule>> getModuleClasses() {
        return moduleList;
    }

    private static Map<String, List<String>> loadModuleFunctionMap() {
        Set allClasses = new Reflections("co.clai.module", new Scanner[0]).getSubTypesOf(AbstractModule.class);
        HashMap<String, List<String>> retMap = new HashMap<String, List<String>>();
        for (Class c : allClasses) {
            List<String> tmpList = null;
            String name = null;
            try {
                Constructor cons = c.getConstructor(DatabaseConnector.class);
                AbstractModule m = (AbstractModule)cons.newInstance(new Object[]{null});
                tmpList = m.getFunctionList();
                if (tmpList == null) {
                    throw new RuntimeException("Module " + m.getModuleName() + " returns null as functionList");
                }
                name = m.getModuleName();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            retMap.put(name, tmpList);
        }
        return retMap;
    }

    private static List<String> loadFunctionList(Map<String, List<String>> tmpModuleFunctionMap) {
        ArrayList<String> retList = new ArrayList<String>();
        for (Map.Entry<String, List<String>> s : tmpModuleFunctionMap.entrySet()) {
            String moduleName = s.getKey();
            for (String f : s.getValue()) {
                retList.add(moduleName + "." + f);
            }
        }
        return retList;
    }

    public static Set<String> getModules() {
        return moduleFunctionMap.keySet();
    }

    public static List<String> getFunctionList() {
        return functionList;
    }
}

