/*
 * Decompiled with CFR 0.152.
 */
package co.clai.util;

import co.clai.util.log.LoggingUtil;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;

public class ResourceUtil {
    private static final Logger logger = LoggingUtil.getDefaultLogger();

    public static String getResourceAsString(String resourceName) {
        return ResourceUtil.getResourceAsString(new ResourceUtil().getClass(), resourceName);
    }

    public static String getResourceAsString(Class<?> c, String resourceName) {
        String text = "";
        try (java.util.Scanner scanner = new java.util.Scanner(c.getResourceAsStream(resourceName), "UTF-8");){
            text = scanner.useDelimiter("\\A").next();
        }
        catch (Exception e) {
            logger.log(Level.INFO, "cannot open resource " + resourceName + ": " + e.getMessage());
        }
        return text;
    }

    public static JSONObject loadJSONResource(String resourceName) {
        String jsonContent = ResourceUtil.getResourceAsString(resourceName);
        return new JSONObject(jsonContent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getResourceAsByteArr(String name) {
        try (InputStream in = new ResourceUtil().getClass().getResourceAsStream(name);){
            byte[] byArray = ByteStreams.toByteArray((InputStream)in);
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Set<String> getResourceInClasspath(String classPath) {
        Reflections reflections = new Reflections(classPath, new Scanner[]{new ResourcesScanner()});
        return reflections.getResources(x -> true);
    }
}

