/*
 * Decompiled with CFR 0.152.
 */
package co.clai;

import co.clai.RequestHandler;
import co.clai.db.DatabaseConnector;
import co.clai.util.cache.ExpiringCache;
import co.clai.util.log.Jetty2LoggerBridge;
import co.clai.util.log.LoggingUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.json.JSONArray;
import org.json.JSONObject;

public class MainHttpListener {
    private static final String JSON_VARNAME_SESSION_KEEP_ALIVE = "sessionKeepAlive";
    public static final String JSON_VARNAME_IP = "ip";
    public static final String JSON_VARNAME_PORTS = "ports";
    public static final String JSON_VARNAME_LISTEN = "listen";
    public static final String JSON_VARNAME_DB = "db";
    public static final String JSON_VARNAME_SITE_URL = "siteUrl";
    Logger logger = LoggingUtil.getDefaultLogger();
    private List<ListenInfo> lInfo = new ArrayList<ListenInfo>();
    private final RequestHandler reqHandler;
    private final Server server;
    private final DatabaseConnector dbCon;
    private final String siteUrl;

    public RequestHandler getReqHandler() {
        return this.reqHandler;
    }

    public DatabaseConnector getDbCon() {
        return this.dbCon;
    }

    public MainHttpListener(JSONObject config) {
        LoggingUtil.setup();
        Jetty2LoggerBridge tmpL = new Jetty2LoggerBridge("jetty web server");
        tmpL.setDebugEnabled(false);
        System.setProperty("org.eclipse.jetty.LEVEL", "WARN");
        Log.setLog((org.eclipse.jetty.util.log.Logger)tmpL);
        Locale.setDefault(Locale.ENGLISH);
        JSONObject dbConfig = config.getJSONObject(JSON_VARNAME_DB);
        this.dbCon = new DatabaseConnector(this, dbConfig);
        this.reqHandler = new RequestHandler(this.dbCon, this);
        this.server = new Server((ThreadPool)new QueuedThreadPool(2048, 1));
        this.siteUrl = config.getString(JSON_VARNAME_SITE_URL);
        JSONArray jsonListeners = config.getJSONArray(JSON_VARNAME_LISTEN);
        for (int i = 0; i < jsonListeners.length(); ++i) {
            JSONObject jListener = jsonListeners.getJSONObject(i);
            String ip = jListener.getString(JSON_VARNAME_IP);
            int[] ports = new int[128];
            JSONArray jPorts = jListener.getJSONArray(JSON_VARNAME_PORTS);
            for (int j = 0; j < jPorts.length(); ++j) {
                ports[j] = jPorts.getInt(j);
                this.logger.log(Level.INFO, "Initializing Listener at " + ip + ":" + ports[j]);
                this.lInfo.add(new ListenInfo(ip, ports));
            }
        }
        for (ListenInfo l : this.lInfo) {
            l.setupServer(this.server);
        }
        int sessionKeepAlive = Integer.parseInt(config.getString(JSON_VARNAME_SESSION_KEEP_ALIVE));
        SessionHandler s = new SessionHandler();
        s.setMaxInactiveInterval(60 * sessionKeepAlive);
        s.setHandler(this.reqHandler);
        ContextHandler c = new ContextHandler("/");
        c.setContextPath("/");
        c.setHandler(s);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(new Handler[]{c});
        this.server.setHandler(contexts);
    }

    public void run() {
        try {
            this.server.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void stop_join() {
        try {
            this.server.stop();
            this.server.join();
            ExpiringCache.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String getSiteUrl() {
        return this.siteUrl;
    }

    private class ListenInfo {
        private final String ip;
        private final int[] ports;

        public ListenInfo(String ip, int[] ports) {
            this.ip = ip;
            this.ports = ports;
        }

        public void setupServer(Server server) {
            for (int port : this.ports) {
                ServerConnector connector = new ServerConnector(server, 1, 1);
                connector.setHost(this.ip);
                connector.setPort(port);
                server.addConnector(connector);
            }
        }
    }
}

