/*
 * Decompiled with CFR 0.152.
 */
package co.clai.html;

import co.clai.html.AbstractRenderer;
import co.clai.html.Builder;
import java.util.List;

public class HtmlTable
extends AbstractRenderer {
    private boolean hasBody = false;

    public HtmlTable() {
        super("<table class='table table-responsive table-striped table-hover table-sm'>");
    }

    public void addHeader(List<String> content) {
        this.appendData("<thead>");
        this.addRow(content);
        this.appendData("</thead>");
    }

    public void addRow(List<String> content) {
        this.appendData("<tr>");
        for (String s : content) {
            this.appendData("<td>" + Builder.escapeForHtml(s) + "</td>");
        }
        this.appendData("</tr>");
    }

    public void startBody() {
        this.hasBody = true;
        this.appendData("<tbody>");
    }

    @Override
    public String finish() {
        if (this.hasBody) {
            this.appendData("</tbody>");
        }
        this.appendData("</table>");
        return super.finish();
    }

    @Override
    public void write(Builder b) {
        throw new RuntimeException("Table should not write a Builder!");
    }

    public void write(HtmlTableRow r) {
        this.appendData(r.finish());
    }

    public class HtmlTableRow
    extends AbstractRenderer {
        public HtmlTableRow() {
            super("<tr>");
        }

        @Override
        public void write(Builder b) {
            this.appendData("<td>" + b.finish() + "</td>");
        }

        @Override
        public void writeText(String text) {
            this.appendData("<td>" + Builder.escapeForHtml(text) + "</td>");
        }

        @Override
        public void writeLink(String location, String text) {
            this.writeLink(location, text, false);
        }

        public void writeLink(String location, String text, boolean newTab) {
            if (newTab) {
                this.appendData("<td><a target='_blank' href='" + location + "'>" + Builder.escapeForHtml(text) + "</a></td>");
            } else {
                this.appendData("<td><a href='" + location + "'>" + Builder.escapeForHtml(text) + "</a></td>");
            }
        }

        @Override
        public String finish() {
            this.appendData("</tr>");
            return super.finish();
        }
    }
}

