/*
 * Decompiled with CFR 0.152.
 */
package co.clai.util.cache;

import co.clai.util.cache.Cache;
import co.clai.util.cache.CacheEntry;
import co.clai.util.cache.ExpiringCacheEntry;
import co.clai.util.log.LoggingUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExpiringCache<T>
implements Cache<T> {
    private static Map<String, ExpiringCacheEntry> data = new HashMap<String, ExpiringCacheEntry>();
    public static final String SEPERATOR = ":@:";
    private final String id;
    private static final List<ExpiringCacheEntry> cacheBuffer = new LinkedList<ExpiringCacheEntry>();
    private static Thread cacheRemover = null;
    public static long cacheTime = 300000L;

    public ExpiringCache(String id) {
        this.id = id;
    }

    @Override
    public void put(String key, T Value) {
        if (cacheRemover == null) {
            cacheRemover = ExpiringCache.startNewCacheRemover();
        }
        String thisKey = this.getFinalKey(key);
        ExpiringCacheEntry entry = new ExpiringCacheEntry(Value.getClass(), Value, cacheBuffer.size(), thisKey);
        data.put(thisKey, entry);
        cacheBuffer.add(entry);
    }

    @Override
    public boolean contains(String key) {
        return data.containsKey(this.getFinalKey(key));
    }

    @Override
    public void delete(String key) {
        cacheBuffer.remove(data.remove(this.getFinalKey(key)).getPosition());
    }

    @Override
    public T retrieve(String key) {
        CacheEntry cacheEntry = data.get(this.getFinalKey(key));
        if (cacheEntry == null) {
            return null;
        }
        return (T)cacheEntry.getData();
    }

    private String getFinalKey(String key) {
        return this.buildFinalKey(this.id, SEPERATOR, key);
    }

    private static final Thread startNewCacheRemover() {
        Thread retThread = new Thread(ExpiringCache::cacheRemoverFunction);
        retThread.start();
        return retThread;
    }

    private static void cacheRemoverFunction() {
        Logger logger = LoggingUtil.getDefaultLogger();
        logger.log(Level.INFO, "[Expiring Cache] starting cache.");
        try {
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "[Expiring Cache] starting sleep interrupted: " + e.getMessage());
        }
        while (!cacheBuffer.isEmpty()) {
            long timeToSleep = cacheBuffer.get(0).getCreatedTimeStamp() + cacheTime - System.currentTimeMillis();
            if (timeToSleep > 0L) {
                try {
                    Thread.sleep(timeToSleep);
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "[Expiring Cache] Sleep interrupted: " + e.getMessage());
                }
            }
            try {
                ExpiringCacheEntry tmpE = cacheBuffer.remove(0);
                if (data.remove(tmpE.getKey()) != null) continue;
                logger.log(Level.WARNING, "key " + tmpE.getKey() + " was not found!");
            }
            catch (Exception e) {
                logger.log(Level.INFO, "[Expiring Cache] Error while removing key: " + e.getMessage());
            }
        }
        logger.log(Level.INFO, "[Expiring Cache] stopping cache.");
        cacheRemover = null;
    }

    public static void stop() {
        if (cacheRemover == null) {
            return;
        }
        cacheBuffer.clear();
        cacheRemover.interrupt();
    }
}

