/*
 * Decompiled with CFR 0.152.
 */
package co.clai.db.model;

import co.clai.access.CommunityAsset;
import co.clai.access.GeneralAsset;
import co.clai.db.DatabaseConnector;
import co.clai.db.DbValue;
import co.clai.db.DbValueType;
import co.clai.db.model.AbstractDbTable;
import co.clai.db.model.Ban;
import co.clai.util.StringStringPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.json.JSONArray;
import org.json.JSONObject;

public class Banlist
extends AbstractDbTable {
    private static final String INFO_COLUMNS_JSON_KEY_NAME = "name";
    private static final String INFO_COLUMNS_JSON_KEY_KEY = "key";
    public static final String DB_TABLE_NAME = "banlist";
    public static final String DB_TABLE_COLUMN_NAME_ID = "id";
    public static final String DB_TABLE_COLUMN_NAME_KEY = "_key";
    public static final String DB_TABLE_COLUMN_NAME_NAME = "name";
    public static final String DB_TABLE_COLUMN_NAME_GAME_ID = "game_id";
    public static final String DB_TABLE_COLUMN_NAME_COMMUNITY_ID = "community_id";
    public static final String DB_TABLE_COLUMN_NAME_INFO_COLUMNS = "info_columns";
    private static final Map<String, DbValueType> columnMap = new HashMap<String, DbValueType>();
    public static final Banlist dummyBanlist = new Banlist();
    private final int id;
    private final String key;
    private final String name;
    private final int gameId;
    private final int communityId;
    private final List<StringStringPair> infoColumns;
    private final Set<String> infoColumnLinks;
    private final String infoColumnsRaw;

    public Banlist() {
        this(-1, null, null, -1, -1, null);
    }

    private Banlist(int id, String key, String name, int gameId, int communityId, String infoColumns) {
        super(DB_TABLE_NAME, columnMap);
        columnMap.put(DB_TABLE_COLUMN_NAME_ID, DbValueType.INTEGER);
        columnMap.put(DB_TABLE_COLUMN_NAME_KEY, DbValueType.STRING);
        columnMap.put("name", DbValueType.STRING);
        columnMap.put(DB_TABLE_COLUMN_NAME_GAME_ID, DbValueType.INTEGER);
        columnMap.put(DB_TABLE_COLUMN_NAME_COMMUNITY_ID, DbValueType.INTEGER);
        columnMap.put(DB_TABLE_COLUMN_NAME_INFO_COLUMNS, DbValueType.STRING);
        this.infoColumns = new ArrayList<StringStringPair>();
        this.infoColumnLinks = new HashSet<String>();
        this.id = id;
        this.name = name;
        this.key = key;
        this.gameId = gameId;
        this.communityId = communityId;
        this.infoColumnsRaw = infoColumns;
        try {
            if (infoColumns != null) {
                JSONArray jA = new JSONArray(infoColumns);
                for (int i = 0; i < jA.length(); ++i) {
                    JSONObject thisElement = jA.getJSONObject(i);
                    this.infoColumns.add(new StringStringPair(thisElement.getString(INFO_COLUMNS_JSON_KEY_KEY), thisElement.getString("name")));
                    if (!thisElement.has("type") || !thisElement.getString("type").equals("link")) continue;
                    this.infoColumnLinks.add(thisElement.getString(INFO_COLUMNS_JSON_KEY_KEY));
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "error while creating extra columns for BanlistMetadata with id " + id + ": " + e.getMessage(), e);
        }
    }

    public int getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public int getGameId() {
        return this.gameId;
    }

    public int getCommunityId() {
        return this.communityId;
    }

    public List<StringStringPair> getInfoColumns() {
        return this.infoColumns;
    }

    public Set<String> getInfoColumnLinks() {
        return this.infoColumnLinks;
    }

    public static void addNewBanlist(DatabaseConnector dbCon, String key, String name, int gameId, int communityId) {
        dbCon.insert(DB_TABLE_NAME, Arrays.asList(DB_TABLE_COLUMN_NAME_KEY, "name", DB_TABLE_COLUMN_NAME_GAME_ID, DB_TABLE_COLUMN_NAME_COMMUNITY_ID, DB_TABLE_COLUMN_NAME_INFO_COLUMNS), Arrays.asList(new DbValue(key), new DbValue(name), new DbValue(gameId), new DbValue(communityId), new DbValue("[]")));
    }

    public static Banlist getBanlistById(DatabaseConnector dbCon, int banId) {
        List<Map<String, DbValue>> results = dbCon.select(DB_TABLE_NAME, DB_TABLE_COLUMN_NAME_ID, new DbValue(banId), dummyBanlist.getColumns());
        if (results.isEmpty()) {
            return null;
        }
        return Banlist.getBanlistFromResult(results.get(0));
    }

    private static Banlist getBanlistFromResult(Map<String, DbValue> parameters) {
        return new Banlist(parameters.get(DB_TABLE_COLUMN_NAME_ID).getInt(), parameters.get(DB_TABLE_COLUMN_NAME_KEY).getString(), parameters.get("name").getString(), parameters.get(DB_TABLE_COLUMN_NAME_GAME_ID).getInt(), parameters.get(DB_TABLE_COLUMN_NAME_COMMUNITY_ID).getInt(), parameters.get(DB_TABLE_COLUMN_NAME_INFO_COLUMNS).getString());
    }

    public static List<Banlist> getAllBanlists(DatabaseConnector dbCon) {
        ArrayList<Banlist> retBanlist = new ArrayList<Banlist>();
        List<Map<String, DbValue>> results = dbCon.select(DB_TABLE_NAME, columnMap);
        for (Map<String, DbValue> r : results) {
            retBanlist.add(Banlist.getBanlistFromResult(r));
        }
        return retBanlist;
    }

    public CommunityAsset getAsset() {
        return new GeneralAsset(this.id, this.communityId);
    }

    public String getInfoColumnsRaw() {
        return this.infoColumnsRaw;
    }

    public void editBanlist(DatabaseConnector dbCon, String newKey, String newName, int newGameId, int newCommunityId, String newInfoColumns) {
        dbCon.updateValue(DB_TABLE_NAME, Arrays.asList(DB_TABLE_COLUMN_NAME_KEY, "name", DB_TABLE_COLUMN_NAME_GAME_ID, DB_TABLE_COLUMN_NAME_COMMUNITY_ID, DB_TABLE_COLUMN_NAME_INFO_COLUMNS), Arrays.asList(new DbValue(newKey), new DbValue(newName), new DbValue(newGameId), new DbValue(newCommunityId), new DbValue(newInfoColumns)), DB_TABLE_COLUMN_NAME_ID, new DbValue(this.id));
    }

    public void removeBanlist(DatabaseConnector dbCon) {
        dbCon.deleteFrom(DB_TABLE_NAME, DB_TABLE_COLUMN_NAME_ID, new DbValue(this.id));
        dbCon.deleteFrom("ban", "banlist_id", new DbValue(this.id));
    }

    public List<String> getActiveBans(DatabaseConnector dbCon) {
        ArrayList<String> retList = new ArrayList<String>();
        List<Ban> banList = Ban.getBansFromBanlistId(dbCon, this.id);
        Date today = new Date(System.currentTimeMillis());
        for (Ban ban : banList) {
            if (ban.isPermaBan()) {
                retList.add(ban.getHash());
                continue;
            }
            if (!ban.getEnd().after(today)) continue;
            retList.add(ban.getHash());
        }
        return retList;
    }
}

