/*
 * Decompiled with CFR 0.152.
 */
package co.clai.module;

import co.clai.AcpSession;
import co.clai.access.AccessibleFunctionHelper;
import co.clai.access.CommunityAsset;
import co.clai.access.GeneralAsset;
import co.clai.db.DatabaseConnector;
import co.clai.db.model.Community;
import co.clai.html.HtmlForm;
import co.clai.html.HtmlPage;
import co.clai.html.HtmlTable;
import co.clai.module.AbstractModule;
import co.clai.module.FunctionResult;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.json.JSONObject;

public class EditCommunity
extends AbstractModule {
    public static final String FUNCTION_NAME_ADD_COMMUNITY = "addCommunity";
    public static final String FUNCTION_NAME_EDIT_FEATURES = "editFeatures";
    public static final String FUNCTION_NAME_EDIT_SETTINGS = "editSettings";
    public static final String LOCATION = "editCommunity";

    public EditCommunity(DatabaseConnector dbCon) {
        super(LOCATION, dbCon);
    }

    @Override
    protected byte[] invokePlain(AcpSession s, Map<String, String[]> parameters) {
        HtmlPage p = new HtmlPage(this.dbCon, "Edit Community", null, null, null, s);
        p.writeWithoutEscaping(HtmlPage.getMessage(parameters));
        if (parameters.get("edit") == null || parameters.get("edit").length == 0) {
            p.writeH1("Edit Communities");
            HtmlTable t = new HtmlTable();
            t.addHeader(Arrays.asList("id", "key", "name", "Edit"));
            t.startBody();
            List<Community> allCommunities = Community.getAllCommunity(this.dbCon);
            for (Community c : allCommunities) {
                if (!s.getThisUser().hasAccess(this.getAccessibleHelper(), new CommunityAsset(c.getId()))) continue;
                HtmlTable.HtmlTableRow row = new HtmlTable.HtmlTableRow(t);
                row.writeText(c.getId() + "");
                row.writeText(c.getKey());
                row.writeText(c.getName() + "");
                HtmlForm fb = new HtmlForm(LOCATION, HtmlForm.Method.GET);
                fb.addHiddenElement("edit", "true");
                fb.addHiddenElement("id", c.getId() + "");
                fb.addSubmit("Edit Community", HtmlForm.ButtonType.PRIMARY);
                row.write(fb);
                t.write(row);
            }
            p.write(t);
            if (s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_ADD_COMMUNITY))) {
                HtmlForm addCommFr = new HtmlForm("editCommunity.addCommunity", HtmlForm.Method.POST);
                addCommFr.addTextElement("Key", "_key", "");
                addCommFr.addTextElement("Name", "longname", "");
                addCommFr.addSubmit("Add new Community", HtmlForm.ButtonType.SUCCESS);
                p.write(addCommFr);
            }
        } else {
            int editedCommunityId = Integer.parseInt(parameters.get("id")[0]);
            Community c = Community.getCommunityById(this.dbCon, editedCommunityId);
            if (s.getThisUser().hasAccess(this.getAccessibleHelper(), new GeneralAsset(c.getId(), c.getId()))) {
                p.writeH2("Edit Community " + c.getName());
                p.writeH3("Features:");
                HtmlForm featureFb = new HtmlForm("editCommunity.editFeatures", HtmlForm.Method.POST);
                String formattedFeatures = c.getFeatures().toString(4);
                featureFb.addTextArea("features", formattedFeatures, 10, 75);
                featureFb.addHiddenElement("id", c.getId() + "");
                if (s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_EDIT_FEATURES), new GeneralAsset(c.getId(), c.getId()))) {
                    featureFb.addSubmit("Change Features", HtmlForm.ButtonType.WARNING);
                }
                p.write(featureFb);
                p.writeH3("Settings:");
                HtmlForm settingsFb = new HtmlForm("editCommunity.editSettings", HtmlForm.Method.POST);
                String formattedSettings = c.getSettings().toString(4);
                settingsFb.addTextArea("settings", formattedSettings, 10, 75);
                settingsFb.addHiddenElement("id", c.getId() + "");
                if (s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_EDIT_FEATURES), new GeneralAsset(c.getId(), c.getId()))) {
                    settingsFb.addSubmit("Change Settings", HtmlForm.ButtonType.WARNING);
                }
                p.write(settingsFb);
            } else {
                p.writeText("access denied!");
                return p.finish().getBytes();
            }
        }
        return p.finish().getBytes();
    }

    @Override
    protected Map<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>> loadFunctions() {
        HashMap<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>> retMap = new HashMap<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>>();
        retMap.put(FUNCTION_NAME_ADD_COMMUNITY, this::addCommunity);
        retMap.put(FUNCTION_NAME_EDIT_FEATURES, this::editFeatures);
        retMap.put(FUNCTION_NAME_EDIT_SETTINGS, this::editSettings);
        return retMap;
    }

    protected FunctionResult addCommunity(AcpSession s, Map<String, String[]> parameters) {
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_ADD_COMMUNITY))) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, LOCATION);
        }
        String communityName = parameters.get("longname")[0];
        String keyName = parameters.get("_key")[0];
        Community.addNewCommunity(this.dbCon, keyName, communityName);
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, LOCATION);
        r.getBuilder().addParameter("edit", "true");
        r.getBuilder().addParameter("id", Community.getCommunityByName(this.dbCon, communityName).getId() + "");
        return r;
    }

    protected FunctionResult editFeatures(AcpSession s, Map<String, String[]> parameters) {
        Community c = Community.getCommunityById(this.dbCon, Integer.parseInt(parameters.get("id")[0]));
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_EDIT_FEATURES), new GeneralAsset(c.getId(), c.getId()))) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, LOCATION);
        }
        JSONObject jO = new JSONObject(parameters.get("features")[0]);
        c.setFeatures(this.dbCon, jO.toString());
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, LOCATION);
        r.getBuilder().addParameter("edit", "true");
        r.getBuilder().addParameter("id", c.getId() + "");
        return r;
    }

    protected FunctionResult editSettings(AcpSession s, Map<String, String[]> parameters) {
        Community c = Community.getCommunityById(this.dbCon, Integer.parseInt(parameters.get("id")[0]));
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_EDIT_SETTINGS), new GeneralAsset(c.getId(), c.getId()))) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, LOCATION);
        }
        JSONObject jO = new JSONObject(parameters.get("settings")[0]);
        c.setSettings(this.dbCon, jO.toString());
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, LOCATION);
        r.getBuilder().addParameter("edit", "true");
        r.getBuilder().addParameter("id", c.getId() + "");
        return r;
    }
}

