/*
 * Decompiled with CFR 0.152.
 */
package co.clai.access;

public class AccessFilter {
    private final String module;
    private final String function;
    private final int communityId;
    private final int assetId;
    private final int gameId;

    public AccessFilter(String path) {
        this(path, -1, -1, -1);
    }

    public AccessFilter(String path, int assetId, int communityId, int gameId) {
        String[] p = path.split("\\.");
        if (p.length < 1) {
            throw new RuntimeException("Path is empty in AccessFilter()");
        }
        this.module = p[0];
        this.function = p.length == 1 ? null : p[1];
        this.assetId = assetId;
        this.communityId = communityId;
        this.gameId = gameId;
    }

    public int getAssetId() {
        return this.assetId;
    }

    public int getCommunityId() {
        return this.communityId;
    }

    public int getGameId() {
        return this.gameId;
    }

    public String getModule() {
        return this.module;
    }

    public String getFunction() {
        return this.function;
    }
}

