/*
 * Decompiled with CFR 0.152.
 */
package co.clai.db;

import co.clai.db.DbValueType;
import co.clai.util.StringUtil;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;

public class DbValue {
    private final DbValueType dbValueType;
    private final Object data;

    public DbValueType getDbValueType() {
        return this.dbValueType;
    }

    public DbValue(Blob b) throws SQLException {
        this(StringUtil.byteArrFromInputStream(b.getBinaryStream()), DbValueType.BLOB);
    }

    public DbValue(String s) {
        this(s, DbValueType.STRING);
    }

    public DbValue(int i) {
        this(new Integer(i), DbValueType.INTEGER);
    }

    public DbValue(double d) {
        this(new Double(d), DbValueType.REAL);
    }

    public DbValue(Timestamp t) {
        this(t, DbValueType.TIMESTAMP);
    }

    public DbValue(Object data, DbValueType dbValueType) {
        this.data = data;
        this.dbValueType = dbValueType;
    }

    public String getString() {
        if (this.dbValueType != DbValueType.STRING) {
            throw new RuntimeException("DbValue is not String in DBValue::getString");
        }
        return (String)this.data;
    }

    public Integer getInteger() {
        if (this.dbValueType != DbValueType.INTEGER) {
            throw new RuntimeException("DbValue is not Integer in DBValue::getInteger");
        }
        return (Integer)this.data;
    }

    public boolean getIntegerAsBool() {
        return this.getInt() != 0;
    }

    public int getInt() {
        if (this.dbValueType != DbValueType.INTEGER) {
            throw new RuntimeException("DbValue is not Integer in DBValue::getInteger");
        }
        return (Integer)this.data;
    }

    public Double getReal() {
        if (this.dbValueType != DbValueType.REAL) {
            throw new RuntimeException("DbValue is not REAL in DBValue::getREAL");
        }
        return (Double)this.data;
    }

    public double getDouble() {
        if (this.dbValueType != DbValueType.REAL) {
            throw new RuntimeException("DbValue is not REAL in DBValue::getREAL");
        }
        return (Double)this.data;
    }

    public Timestamp getTimestamp() {
        if (this.dbValueType != DbValueType.TIMESTAMP) {
            throw new RuntimeException("DbValue is not Timestamp in DBValue::getTimestamp");
        }
        return (Timestamp)this.data;
    }

    public Blob getBlob(Connection con) {
        Blob blob;
        if (this.dbValueType != DbValueType.BLOB) {
            throw new RuntimeException("DbValue is not Blob in DBValue::getString");
        }
        try {
            blob = con.createBlob();
            blob.setBytes(1L, (byte[])this.data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return blob;
    }

    public String getBlobAsString() {
        if (this.dbValueType != DbValueType.BLOB) {
            throw new RuntimeException("DbValue is not Blob in DBValue::getString");
        }
        return new String((byte[])this.data);
    }

    public byte[] getBlobAsByteArr() {
        if (this.dbValueType != DbValueType.BLOB) {
            throw new RuntimeException("DbValue is not Blob in DBValue::getBlobAsByteArr");
        }
        return (byte[])this.data;
    }

    public static DbValue newBlob(String config) {
        return new DbValue(config.getBytes(), DbValueType.BLOB);
    }

    public static DbValue newBooleanAsInteger(boolean data) {
        if (data) {
            return new DbValue(1);
        }
        return new DbValue(0);
    }
}

