/*
 * Decompiled with CFR 0.152.
 */
package co.clai.module;

import co.clai.AcpSession;
import co.clai.access.AccessibleFunctionHelper;
import co.clai.access.AccessibleModuleHelper;
import co.clai.access.AssetServer;
import co.clai.db.DatabaseConnector;
import co.clai.db.model.Community;
import co.clai.db.model.Game;
import co.clai.db.model.Server;
import co.clai.db.model.ServerSetting;
import co.clai.game.AbstractGame;
import co.clai.game.AbstractGameUtil;
import co.clai.html.HtmlForm;
import co.clai.html.HtmlPage;
import co.clai.html.HtmlResponsiveColumns;
import co.clai.html.HtmlTable;
import co.clai.module.AbstractModule;
import co.clai.module.FunctionResult;
import co.clai.util.IntStringPair;
import co.clai.util.StringStringPair;
import co.clai.util.ValueValuePair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.logging.Level;

public class EditServer
extends AbstractModule {
    public static final String LOCATION = "editServer";
    public static final String TITLE = "Edit server settings";
    public static final String FUNCTION_NAME_ADD_SERVER = "addServer";
    public static final String FUNCTION_NAME_EDIT_SERVER = "editServer";
    public static final String FUNCTION_NAME_REMOVE_SERVER = "removeServer";
    public static final String FUNCTION_NAME_ADD_SETTING = "addSetting";
    public static final String FUNCTION_NAME_EDIT_SETTING = "editSetting";
    public static final String FUNCTION_NAME_REMOVE_SETTING = "removeSetting";
    private static final String GET_PARAM = "edit";
    private static final Map<String, AbstractGame> gameMap = new HashMap<String, AbstractGame>();

    public EditServer(DatabaseConnector dbCon) {
        super("editServer", dbCon);
        List<AbstractGame> tmpList = AbstractGameUtil.getAllGames();
        for (AbstractGame aG : tmpList) {
            gameMap.put(aG.getKey(), aG);
        }
    }

    @Override
    protected byte[] invokePlain(AcpSession s, Map<String, String[]> parameters) {
        HtmlPage p = new HtmlPage(this.dbCon, TITLE, null, null, null, s);
        p.writeH1("Edit Server Settings");
        HtmlTable serverListT = new HtmlTable();
        serverListT.addHeader(Arrays.asList("id", "key", "name", "game", "community", "banlist_ids", GET_PARAM, "delete"));
        List<Server> servers = Server.getAllServer(this.dbCon);
        for (Server server : servers) {
            if (!s.getThisUser().hasAccess(new AccessibleModuleHelper("editServer"), server.getAsset())) continue;
            HtmlTable.HtmlTableRow r = new HtmlTable.HtmlTableRow(serverListT);
            r.writeText(server.getId() + "");
            r.writeText(server.getKey());
            r.writeText(server.getName());
            try {
                r.writeText(Game.getGameById(this.dbCon, server.getGameId()).getName());
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error while creating game with id " + server.getGameId() + ": " + e.getMessage());
                r.writeText("unknown game");
            }
            try {
                r.writeText(Community.getCommunityById(this.dbCon, server.getCommunityId()).getName());
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error while creating Community with id " + server.getCommunityId() + ": " + e.getMessage());
                r.writeText("unknown community");
            }
            StringJoiner sb = new StringJoiner(",");
            for (Integer n : server.getBanlistIds()) {
                sb.add(n.toString());
            }
            r.writeText(sb.toString());
            if (s.getThisUser().hasAccess(new AccessibleFunctionHelper("editServer", "editServer"), server.getAsset())) {
                HtmlForm editForm = new HtmlForm(this.getModuleName(), HtmlForm.Method.GET);
                editForm.addHiddenElement(GET_PARAM, "editServer");
                editForm.addHiddenElement("id", server.getId() + "");
                editForm.addSubmit("Edit", HtmlForm.ButtonType.WARNING);
                r.write(editForm);
            }
            if (s.getThisUser().hasAccess(new AccessibleFunctionHelper("editServer", FUNCTION_NAME_REMOVE_SERVER), server.getAsset())) {
                HtmlForm removeForm = new HtmlForm(this.getModuleName() + "." + FUNCTION_NAME_REMOVE_SERVER, HtmlForm.Method.POST);
                removeForm.addHiddenElement("id", server.getId() + "");
                removeForm.addSubmit("Remove", HtmlForm.ButtonType.DANGER);
                r.write(removeForm);
            }
            serverListT.write(r);
        }
        p.writeHline();
        p.write(serverListT);
        p.writeHline();
        ArrayList<ValueValuePair> selectionCommunityValues = new ArrayList<ValueValuePair>();
        for (Community c : Community.getAllCommunity(this.dbCon)) {
            if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_ADD_SERVER), c.getAsset())) continue;
            selectionCommunityValues.add(new IntStringPair(c.getId(), c.getName()));
        }
        if (parameters.get(GET_PARAM) == null || parameters.get(GET_PARAM).length == 0) {
            if (s.getThisUser().hasAccess(new AccessibleFunctionHelper("editServer", FUNCTION_NAME_ADD_SERVER))) {
                p.writeH2("Add new Server:");
                HtmlForm htmlForm = new HtmlForm(this.getModuleName() + "." + FUNCTION_NAME_ADD_SERVER, HtmlForm.Method.POST);
                htmlForm.addTextElement("key", "_key", "");
                htmlForm.addTextElement("name", "name", "");
                htmlForm.addSelectionDropdown("Game", "game_id", Game.getGameListSelection(this.dbCon));
                htmlForm.addSelectionDropdown("Community", "community_id", selectionCommunityValues);
                htmlForm.addSubmit("Add new Server", HtmlForm.ButtonType.SUCCESS);
                p.write(htmlForm);
            }
        } else {
            HtmlResponsiveColumns htmlResponsiveColumns = new HtmlResponsiveColumns();
            htmlResponsiveColumns.startColumn(6);
            htmlResponsiveColumns.writeH3("Edit Server default settings:");
            Server server = Server.getServerById(this.dbCon, Integer.parseInt(parameters.get("id")[0]));
            if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper("editServer", "editServer"), server.getAsset())) {
                p.writeText("No access");
                return p.finish().getBytes();
            }
            HtmlForm editServerForm = new HtmlForm(this.getModuleName() + "." + "editServer", HtmlForm.Method.POST);
            editServerForm.addHiddenElement("id", server.getId() + "");
            editServerForm.addTextElement("key", "_key", server.getKey());
            editServerForm.addTextElement("name", "name", server.getName());
            editServerForm.addSelectionDropdown("Game", "game_id", Game.getGameListSelection(this.dbCon), server.getGameId() + "");
            editServerForm.addSelectionDropdown("Community", "community_id", selectionCommunityValues, server.getCommunityId() + "");
            StringJoiner sj = new StringJoiner(",");
            for (Integer i : server.getBanlistIds()) {
                sj.add(i.toString());
            }
            editServerForm.addTextElement("Banlists", "banlist_ids", sj.toString());
            editServerForm.addSubmit("Edit Settings", HtmlForm.ButtonType.WARNING);
            htmlResponsiveColumns.write(editServerForm);
            htmlResponsiveColumns.startColumn(6);
            htmlResponsiveColumns.writeH3("Edit all Server settings:");
            HashSet<String> hashSet = new HashSet<String>();
            AbstractGame game = gameMap.get(Game.getGameById(this.dbCon, server.getGameId()).getKey());
            for (ServerSetting serverSetting : ServerSetting.getAllServerSettingByServerId(this.dbCon, server.getId())) {
                hashSet.add(serverSetting.getSettingKey());
                htmlResponsiveColumns.write(game.renderOption(s, serverSetting));
                htmlResponsiveColumns.writeHline();
            }
            htmlResponsiveColumns.writeHline();
            htmlResponsiveColumns.writeH3("Add new option:");
            ArrayList<ValueValuePair> selectionList = new ArrayList<ValueValuePair>();
            for (StringStringPair pair : game.getAvailableOptions()) {
                if (hashSet.contains(pair.getId())) continue;
                selectionList.add(new StringStringPair(pair.getId(), pair.getName()));
            }
            HtmlForm htmlForm = new HtmlForm(this.getModuleName() + "." + FUNCTION_NAME_ADD_SETTING, HtmlForm.Method.POST);
            htmlForm.addHiddenElement("server_id", server.getId() + "");
            htmlForm.addSelectionDropdown("Option", "setting_key", selectionList);
            htmlForm.addSubmit("Add new Option", HtmlForm.ButtonType.SUCCESS);
            htmlResponsiveColumns.write(htmlForm);
            p.write(htmlResponsiveColumns);
        }
        return p.finish().getBytes();
    }

    @Override
    protected Map<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>> loadFunctions() {
        HashMap<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>> retMap = new HashMap<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>>();
        retMap.put(FUNCTION_NAME_ADD_SERVER, this::addServer);
        retMap.put("editServer", this::editServer);
        retMap.put(FUNCTION_NAME_REMOVE_SERVER, this::removeServer);
        retMap.put(FUNCTION_NAME_ADD_SETTING, this::addSetting);
        retMap.put(FUNCTION_NAME_EDIT_SETTING, this::editSetting);
        retMap.put(FUNCTION_NAME_REMOVE_SETTING, this::removeSetting);
        return retMap;
    }

    private FunctionResult addServer(AcpSession s, Map<String, String[]> parameters) {
        String key = parameters.get("_key")[0];
        String name1 = parameters.get("name")[0];
        int gameId = Integer.parseInt(parameters.get("game_id")[0]);
        int communityId = Integer.parseInt(parameters.get("community_id")[0]);
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_ADD_SERVER), new AssetServer(0, communityId, gameId))) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, "editServer");
        }
        Server.addNewServer(this.dbCon, key, name1, gameId, communityId);
        return new FunctionResult(FunctionResult.Status.OK, "editServer");
    }

    private FunctionResult editServer(AcpSession s, Map<String, String[]> parameters) {
        int id = Integer.parseInt(parameters.get("id")[0]);
        String key = parameters.get("_key")[0];
        String name1 = parameters.get("name")[0];
        int gameId = Integer.parseInt(parameters.get("game_id")[0]);
        int communityId = Integer.parseInt(parameters.get("community_id")[0]);
        String banlistIds = parameters.get("banlist_ids")[0];
        Server server = Server.getServerById(this.dbCon, id);
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), "editServer"), server.getAsset())) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, "editServer");
        }
        server.edit(this.dbCon, key, name1, gameId, communityId, banlistIds);
        return new FunctionResult(FunctionResult.Status.OK, "editServer", "Server successfully edited!");
    }

    private FunctionResult removeServer(AcpSession s, Map<String, String[]> parameters) {
        int id = Integer.parseInt(parameters.get("id")[0]);
        Server server = Server.getServerById(this.dbCon, id);
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_REMOVE_SERVER), server.getAsset())) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, "editServer");
        }
        server.delete(this.dbCon);
        return new FunctionResult(FunctionResult.Status.OK, "editServer", "Server removed.");
    }

    private FunctionResult addSetting(AcpSession s, Map<String, String[]> parameters) {
        int serverId = Integer.parseInt(parameters.get("server_id")[0]);
        String settingKey = parameters.get("setting_key")[0];
        Server server = Server.getServerById(this.dbCon, serverId);
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_ADD_SETTING), server.getAsset())) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, "editServer");
        }
        AbstractGame game = gameMap.get(Game.getGameById(this.dbCon, server.getGameId()).getKey());
        ServerSetting.addNewServerSetting(this.dbCon, serverId, settingKey, game.getDefaultOption(settingKey));
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, "editServer");
        r.getBuilder().addParameter(GET_PARAM, GET_PARAM);
        r.getBuilder().addParameter("id", server.getId() + "");
        return r;
    }

    private FunctionResult editSetting(AcpSession s, Map<String, String[]> parameters) {
        int id = Integer.parseInt(parameters.get("id")[0]);
        String data = parameters.get("data")[0];
        ServerSetting setting = ServerSetting.getServerSettingById(this.dbCon, id);
        Server server = Server.getServerById(this.dbCon, setting.getServerId());
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_EDIT_SETTING), server.getAsset())) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, "editServer");
        }
        setting.edit(this.dbCon, data);
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, "editServer");
        r.getBuilder().addParameter(GET_PARAM, GET_PARAM);
        r.getBuilder().addParameter("id", server.getId() + "");
        return r;
    }

    private FunctionResult removeSetting(AcpSession s, Map<String, String[]> parameters) {
        int id = Integer.parseInt(parameters.get("id")[0]);
        ServerSetting setting = ServerSetting.getServerSettingById(this.dbCon, id);
        Server server = Server.getServerById(this.dbCon, setting.getServerId());
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_EDIT_SETTING), server.getAsset())) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, "editServer");
        }
        setting.delete(this.dbCon);
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, "editServer");
        r.getBuilder().addParameter(GET_PARAM, GET_PARAM);
        r.getBuilder().addParameter("id", setting.getServerId() + "");
        return r;
    }
}

