/*
 * Decompiled with CFR 0.152.
 */
package co.clai.storage;

import co.clai.db.DatabaseConnector;
import co.clai.db.model.Storage;
import co.clai.storage.AbstractStorage;
import co.clai.storage.StorageSearchEntry;
import co.clai.util.StringStringPair;
import co.clai.util.ValueValuePair;
import co.clai.util.cache.Cache;
import co.clai.util.cache.ExpiringCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.json.JSONObject;

public class SingleHttpRemoteStorage
extends AbstractStorage {
    private static final String GENERIC_IDENTIFIER = "file";
    private final Cache<byte[]> dataCache;
    private final String JSON_CONFIG_KEY_URL = "url";
    private final String JSON_CONFIG_KEY_HTTPUSER = "httpUser";
    private final String JSON_CONFIG_KEY_HTTPPWD = "httpPwd";
    private final Storage storage;
    private final boolean useHttpPwd;
    private final String url;
    private final String httpUser;
    private final String httpPwd;

    public SingleHttpRemoteStorage(Storage storage) {
        this.storage = storage;
        if (storage == null || storage.getConfig() == null) {
            this.useHttpPwd = false;
            this.url = null;
            this.httpUser = null;
            this.httpPwd = null;
            this.dataCache = null;
        } else {
            JSONObject config = storage.getConfig();
            this.url = config.getString("url");
            this.dataCache = new ExpiringCache<byte[]>(this.url);
            if (config.has("httpUser")) {
                this.useHttpPwd = true;
                this.httpUser = config.getString("httpUser");
                this.httpPwd = config.getString("httpPwd");
            } else {
                this.useHttpPwd = false;
                this.httpUser = null;
                this.httpPwd = null;
            }
        }
    }

    @Override
    public String getStorageTypeName() {
        return "single_http_remote";
    }

    @Override
    public boolean needsApproval() {
        return false;
    }

    @Override
    public boolean isCloud() {
        return false;
    }

    @Override
    public byte[] getData(String identifier) {
        return this.getFileContent();
    }

    @Override
    public List<ValueValuePair> getFileListByDate(DatabaseConnector dbCon, Date from, Date to) {
        return this.getFileList(dbCon);
    }

    @Override
    public List<ValueValuePair> getFileList(DatabaseConnector dbCon) {
        return Arrays.asList(new StringStringPair(GENERIC_IDENTIFIER, this.storage.getName()));
    }

    @Override
    public List<StorageSearchEntry> searchForEntries(DatabaseConnector dbCon, String regExp) {
        String content = new String(this.getFileContent());
        return SingleHttpRemoteStorage.getSearchResult(GENERIC_IDENTIFIER, this.storage == null ? GENERIC_IDENTIFIER : this.storage.getName(), regExp, content);
    }

    private byte[] getFileContent() {
        if (this.useHttpPwd) {
            return SingleHttpRemoteStorage.requestCachedPOSTData(this.url, new ArrayList<StringStringPair>(), this.dataCache, this.httpUser, this.httpPwd);
        }
        return SingleHttpRemoteStorage.requestCachedPOSTData(this.url, new ArrayList<StringStringPair>(), this.dataCache);
    }

    @Override
    public List<StorageSearchEntry> searchForEntries(DatabaseConnector dbCon, String searchQuery, Date start, Date end) {
        return this.searchForEntries(dbCon, searchQuery);
    }

    @Override
    public void pushIndex(DatabaseConnector dbCon, String identifier, String name, long timestamp, String clientIp) {
        throw new RuntimeException("operation not supported");
    }
}

