/*
 * Decompiled with CFR 0.152.
 */
package co.clai.util.cache;

import co.clai.util.cache.Cache;
import co.clai.util.cache.CacheEntry;
import java.util.HashMap;
import java.util.Map;

public class PermanentCache<T>
implements Cache<T> {
    private static Map<String, CacheEntry> data = new HashMap<String, CacheEntry>();
    public static final String SEPERATOR = ":@:";
    private final String id;

    public PermanentCache(String id) {
        this.id = id;
    }

    @Override
    public void put(String key, T Value) {
        data.put(this.getFinalKey(key), new CacheEntry(Value.getClass(), Value));
    }

    @Override
    public boolean contains(String key) {
        return data.containsKey(this.getFinalKey(key));
    }

    @Override
    public void delete(String key) {
        data.remove(this.getFinalKey(key));
    }

    @Override
    public T retrieve(String key) {
        CacheEntry cacheEntry = data.get(this.getFinalKey(key));
        if (cacheEntry == null) {
            return null;
        }
        return (T)cacheEntry.getData();
    }

    private String getFinalKey(String key) {
        return this.buildFinalKey(this.id, SEPERATOR, key);
    }
}

