/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqla.io;

import com.mysql.cj.api.mysqla.io.NativeProtocol;
import com.mysql.cj.api.mysqla.io.PacketHeader;
import com.mysql.cj.api.mysqla.io.PacketPayload;
import com.mysql.cj.api.mysqla.io.PacketReader;
import com.mysql.cj.core.Messages;
import com.mysql.cj.mysqla.io.Buffer;
import java.io.IOException;
import java.util.Optional;

public class MultiPacketReader
implements PacketReader {
    private PacketReader packetReader;

    public MultiPacketReader(PacketReader packetReader) {
        this.packetReader = packetReader;
    }

    @Override
    public PacketHeader readHeader() throws IOException {
        return this.packetReader.readHeader();
    }

    @Override
    public PacketPayload readPayload(Optional<PacketPayload> reuse, int packetLength) throws IOException {
        PacketPayload buf = this.packetReader.readPayload(reuse, packetLength);
        if (packetLength == 0xFFFFFF) {
            buf.setPosition(0xFFFFFF);
            Buffer multiPacket = null;
            int multiPacketLength = -1;
            byte multiPacketSeq = this.getPacketSequence();
            do {
                PacketHeader hdr = this.readHeader();
                multiPacketLength = hdr.getPacketLength();
                if (multiPacket == null) {
                    multiPacket = new Buffer(multiPacketLength);
                }
                if ((multiPacketSeq = (byte)(multiPacketSeq + 1)) != hdr.getPacketSequence()) {
                    throw new IOException(Messages.getString("PacketReader.10"));
                }
                this.packetReader.readPayload(Optional.of(multiPacket), multiPacketLength);
                buf.writeBytes(NativeProtocol.StringLengthDataType.STRING_FIXED, multiPacket.getByteBuffer(), 0, multiPacketLength);
            } while (multiPacketLength == 0xFFFFFF);
            buf.setPosition(0);
        }
        return buf;
    }

    @Override
    public byte getPacketSequence() {
        return this.packetReader.getPacketSequence();
    }

    @Override
    public void resetPacketSequence() {
        this.packetReader.resetPacketSequence();
    }

    @Override
    public PacketReader undecorateAll() {
        return this.packetReader.undecorateAll();
    }

    @Override
    public PacketReader undecorate() {
        return this.packetReader;
    }
}

