/*
 * Decompiled with CFR 0.152.
 */
package co.clai.html;

import co.clai.html.AbstractRenderer;
import co.clai.html.Builder;
import co.clai.util.ValueValuePair;
import java.util.List;
import java.util.Set;

public class HtmlForm
extends AbstractRenderer {
    public HtmlForm(String actionTarget, Method method) {
        this(actionTarget, method, Direction.HORIZONTAL);
    }

    public HtmlForm(String actionTarget, Method method, Direction direction) {
        super("<form action=\"" + actionTarget + "\" method=" + method.name().toLowerCase() + HtmlForm.appendCssIdClassIfNotNull(null, direction == null ? "" : direction.name().toLowerCase()) + ">");
    }

    public void addTextElement(String label, String name, String value) {
        this.addInputElement(label, name, InputType.TEXT, value, false);
    }

    public void addPasswordElement(String label, String name) {
        this.addInputElement(label, name, InputType.PASSWORD, null, false);
    }

    public void addHiddenElement(String name, String value) {
        this.addInputElement(null, name, InputType.HIDDEN, value, false);
    }

    public void addCheckbox(String label, String name, String value) {
        this.addInputElement(label, name, InputType.CHECKBOX, value, false);
    }

    public void addCheckbox(String label, String name, String value, boolean checked) {
        this.addInputElement(label, name, InputType.CHECKBOX, value, checked);
    }

    public void addTextArea(String name, String value, int rows, int columns) {
        this.appendData("<div class='form-group'><div class='col-sm-offset-2 col-sm-10'>");
        this.appendData("<textarea name='" + name + "' class='form-control form-control-sm' ");
        this.appendData("rows='" + rows + "' cols='" + columns + "' >");
        this.appendData(value == null ? "" : Builder.escapeForHtml(value));
        this.appendData("</textarea>");
        this.appendData("</div></div>");
    }

    public void addSelectionDropdown(String label, String name, List<ValueValuePair> values) {
        this.addSelectionDropdown(label, name, values, "-1");
    }

    public void addSelectionDropdown(String label, String name, List<ValueValuePair> values, String selectedValue) {
        this.appendData("<div class='form-group'>");
        if (label != null) {
            this.appendData("<label for='" + name + "' class='col-sm-2 control-label'>" + label + ":</label>");
            this.appendData("<div class='col-sm-10'>");
        } else {
            this.appendData("<div class='col-sm-offset-2 col-sm-10'>");
        }
        this.appendData("<select name='" + name + "' class='form-control form-control-sm'>");
        for (ValueValuePair p : values) {
            if (p.getId().equals(selectedValue)) {
                this.appendData("<option value='" + p.getId() + "' selected='selected' >" + p.getName() + "</option>");
                continue;
            }
            this.appendData("<option value='" + p.getId() + "'>" + p.getName() + "</option>");
        }
        this.appendData("</select></div></div>");
    }

    public void addSubmit(String value) {
        this.addSubmit(value, ButtonType.SECONDARY);
    }

    public void addSubmit(String value, ButtonType type) {
        this.appendData("<input value='" + value + "' type='submit' class='btn btn-sm btn-" + type.name().toLowerCase() + "' / >");
    }

    public void addCheckboxGroup(String label, String name, List<ValueValuePair> values, Set<String> selectedValues) {
        this.appendData("<div class='form-group'>");
        this.appendData("<label for='" + name + "' class='control-label'>" + label + ":</label>");
        this.appendData("<div class='col-sm-offset-2'>");
        for (ValueValuePair pair : values) {
            String value = pair.getId();
            this.addInputElement(pair.getName(), name, InputType.CHECKBOX, value, selectedValues.contains(value));
        }
        this.appendData("</div></div>");
    }

    private void addInputElement(String label, String name, InputType type, String value, boolean checked) {
        if (type != InputType.HIDDEN) {
            this.appendData("<div class='form-group'>");
            if (label != null) {
                this.appendData("<label for='" + name + "' class='col-sm-4 control-label'>" + label + ":</label>");
                this.appendData("<div class='col-sm-8'>");
            } else {
                this.appendData("<div class='col-sm-offset-4 col-sm-8'>");
            }
        }
        this.appendData("<input type='" + type.name().toLowerCase() + "' name='" + name + "' ");
        this.appendData("value='" + (value == null ? "" : Builder.escapeForHtml(value)) + "' class='form-control form-control-sm'");
        if (checked) {
            this.appendData(" checked=\"checked\" ");
        }
        this.appendData(" />");
        if (type != InputType.HIDDEN) {
            this.appendData("</div></div>");
        }
    }

    @Override
    public String finish() {
        this.appendData("</form>");
        return super.finish();
    }

    @Override
    public void write(Builder b) {
        throw new RuntimeException("Form Renderer should not write a Builder!");
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }

    public static enum ButtonType {
        PRIMARY,
        SECONDARY,
        SUCCESS,
        INFO,
        WARNING,
        DANGER,
        LINK;

    }

    public static enum InputType {
        TEXT,
        PASSWORD,
        HIDDEN,
        SUBMIT,
        TEXTAREA,
        CHECKBOX;

    }

    public static enum Method {
        POST,
        GET;

    }
}

