/*
 * Decompiled with CFR 0.152.
 */
package co.clai.module;

import co.clai.AcpSession;
import co.clai.access.AccessibleHelper;
import co.clai.db.DatabaseConnector;
import co.clai.db.model.Location;
import co.clai.html.AbstractRenderer;
import co.clai.html.Builder;
import co.clai.module.AbstractModule;
import co.clai.module.FunctionResult;
import co.clai.remote.AbstractRemoteConnection;
import co.clai.remote.OAuth2Helper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.logging.Level;

public class OAuth2
extends AbstractModule {
    private static final String SESSION_KEY_OAUTH2_LOCATION = "oauth2Location";
    public static final String FUNCTION_NAME_CALLBACK = "callback";
    public static final String FUNCTION_NAME_LOGIN = "login";
    public static final String LOCATION = "oauth2";

    public OAuth2(DatabaseConnector dbCon) {
        super(LOCATION, dbCon, new AccessibleHelper(true));
    }

    @Override
    protected byte[] invokePlain(AcpSession s, Map<String, String[]> parameters) {
        AbstractRenderer r = new AbstractRenderer(""){

            @Override
            public void write(Builder b) {
                this.appendData(b.finish());
            }
        };
        r.writeLink("index", "return to main page");
        return r.finish().getBytes();
    }

    @Override
    protected Map<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>> loadFunctions() {
        HashMap<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>> allFunctions = new HashMap<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>>();
        allFunctions.put(FUNCTION_NAME_LOGIN, this::login);
        allFunctions.put(FUNCTION_NAME_CALLBACK, this::callback);
        return allFunctions;
    }

    private FunctionResult login(AcpSession s, Map<String, String[]> parameters) {
        try {
            int locationId = Integer.parseInt(parameters.get(Location.DB_TABLE_COLUMN_NAME_ID)[0]);
            s.getSession().setAttribute(SESSION_KEY_OAUTH2_LOCATION, (Object)new Integer(locationId));
            AbstractRemoteConnection rl = AbstractRemoteConnection.getRemoteFromLocation(Location.getLocationById(this.dbCon, locationId));
            FunctionResult r = OAuth2Helper.generateRedirect(this.dbCon.getListener().getSiteUrl(), rl.getOAuth2Data());
            return r;
        }
        catch (Exception e) {
            this.logger.log(Level.INFO, "OAuth2 Error: ", e);
            return new FunctionResult(FunctionResult.Status.FAILED, "index", "failed to get OAuth2 path!");
        }
    }

    private FunctionResult callback(AcpSession s, Map<String, String[]> parameters) {
        try {
            for (Map.Entry<String, String[]> e : parameters.entrySet()) {
                this.logger.log(Level.INFO, e.getKey() + ":" + e.getValue()[0]);
            }
            int locationId = (Integer)s.getSession().getAttribute(SESSION_KEY_OAUTH2_LOCATION);
            s.getSession().removeAttribute(SESSION_KEY_OAUTH2_LOCATION);
            AbstractRemoteConnection c = AbstractRemoteConnection.getRemoteFromLocation(Location.getLocationById(this.dbCon, locationId));
            if (!c.canDoOAuth2Login()) {
                return new FunctionResult(FunctionResult.Status.FAILED, "index", "Location does not Support OAuth2 login.");
            }
            s.setUser(c.getUserWithOAuth2Code(this.dbCon, parameters, locationId));
            return new FunctionResult(FunctionResult.Status.FAILED, "index", "Successfully logged in!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new FunctionResult(FunctionResult.Status.FAILED, "index", "Error during callback.");
        }
    }
}

