/*
 * Decompiled with CFR 0.152.
 */
package co.clai.storage;

import co.clai.db.DatabaseConnector;
import co.clai.db.model.Storage;
import co.clai.db.model.StorageIndex;
import co.clai.storage.AbstractStorage;
import co.clai.storage.StorageSearchEntry;
import co.clai.util.StringStringPair;
import co.clai.util.ValueValuePair;
import co.clai.util.cache.Cache;
import co.clai.util.cache.PermanentCache;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.json.JSONArray;
import org.json.JSONObject;

public class IndexedRemotePhpStorage
extends AbstractStorage {
    private final Cache<byte[]> dataCache;
    private final String JSON_CONFIG_KEY_BASE_URL = "baseUrl";
    private final String JSON_CONFIG_KEY_HTTPUSER = "httpUser";
    private final String JSON_CONFIG_KEY_HTTPPWD = "httpPwd";
    private final String JSON_CONFIG_KEY_IP_WHITELIST = "ip_whitelist";
    private final Storage storage;
    private final boolean useHttpPwd;
    private final String baseUrl;
    private final String httpUser;
    private final String httpPwd;
    private final Set<String> ipWhiteList;

    public IndexedRemotePhpStorage(Storage storage) {
        this.storage = storage;
        if (storage == null || storage.getConfig() == null) {
            this.useHttpPwd = false;
            this.baseUrl = null;
            this.httpUser = null;
            this.httpPwd = null;
            this.dataCache = null;
            this.ipWhiteList = null;
        } else {
            if (!storage.isHasLocalIndex()) {
                logger.log(Level.WARNING, "storage is not indexed, no results will be produced");
            }
            JSONObject config = storage.getConfig();
            this.baseUrl = config.getString("baseUrl");
            if (config.has("ip_whitelist")) {
                JSONArray jWhiteArr = config.getJSONArray("ip_whitelist");
                this.ipWhiteList = new HashSet<String>();
                for (int i = 0; i < jWhiteArr.length(); ++i) {
                    this.ipWhiteList.add(jWhiteArr.getString(i));
                }
            } else {
                this.ipWhiteList = null;
            }
            this.dataCache = new PermanentCache<byte[]>(this.baseUrl);
            if (config.has("httpUser")) {
                this.useHttpPwd = true;
                this.httpUser = config.getString("httpUser");
                this.httpPwd = config.getString("httpPwd");
            } else {
                this.useHttpPwd = false;
                this.httpUser = null;
                this.httpPwd = null;
            }
        }
    }

    @Override
    public String getStorageTypeName() {
        return "indexed_remote_php";
    }

    @Override
    public boolean needsApproval() {
        return false;
    }

    @Override
    public boolean isCloud() {
        return false;
    }

    @Override
    public byte[] getData(String identifier) {
        String url = this.baseUrl + identifier;
        if (this.useHttpPwd) {
            return IndexedRemotePhpStorage.requestCachedPOSTData(url, new ArrayList<StringStringPair>(), this.dataCache, this.httpUser, this.httpPwd);
        }
        return IndexedRemotePhpStorage.requestCachedPOSTData(url, new ArrayList<StringStringPair>(), this.dataCache);
    }

    @Override
    public List<ValueValuePair> getFileListByDate(DatabaseConnector dbCon, Date from, Date to) {
        ArrayList<ValueValuePair> retList = new ArrayList<ValueValuePair>();
        List<StorageIndex> list = StorageIndex.getAllStorageIndexByStorageId(dbCon, this.storage.getId());
        for (StorageIndex stInd : list) {
            try {
                if (!stInd.getDatetime().after(from) || !stInd.getDatetime().before(to)) continue;
                retList.add(new StringStringPair(stInd.getIdentifier(), stInd.getName()));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Storage Index " + stInd.getId() + " has date null: " + e.getMessage());
            }
        }
        return retList;
    }

    @Override
    public List<StorageSearchEntry> searchForEntries(DatabaseConnector dbCon, String searchQuery) {
        return this.searchForEntries(dbCon, searchQuery, new Date(0L), new Date(System.currentTimeMillis()));
    }

    @Override
    public List<StorageSearchEntry> searchForEntries(DatabaseConnector dbCon, String searchQuery, Date start, Date end) {
        ArrayList<StorageSearchEntry> resultList = new ArrayList<StorageSearchEntry>();
        List<ValueValuePair> fileList = this.getFileListByDate(dbCon, start, end);
        for (ValueValuePair pair : fileList) {
            resultList.addAll(IndexedRemotePhpStorage.getSearchResult(pair.getId(), pair.getName(), searchQuery, new String(this.getData(pair.getId()))));
        }
        return resultList;
    }

    @Override
    public void pushIndex(DatabaseConnector dbCon, String identifier, String name, long timestamp, String clientIp) {
        if (this.ipWhiteList != null && !this.ipWhiteList.contains(clientIp)) {
            throw new RuntimeException("client IP " + clientIp + " not in whitelist: ");
        }
        StorageIndex.addNewStorage(dbCon, name, identifier, this.storage.getId(), timestamp);
    }
}

