/*
 * Decompiled with CFR 0.152.
 */
package co.clai.storage;

import co.clai.db.DatabaseConnector;
import co.clai.db.model.Storage;
import co.clai.storage.AbstractStorage;
import co.clai.storage.DateIdPair;
import co.clai.storage.StorageSearchEntry;
import co.clai.util.FileUtil;
import co.clai.util.ResourceUtil;
import co.clai.util.StringStringPair;
import co.clai.util.StringUtil;
import co.clai.util.ValueValuePair;
import co.clai.util.cache.Cache;
import co.clai.util.cache.ExpiringCache;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.json.JSONObject;

public class LocalFileSystemStorage
extends AbstractStorage {
    private final Cache<List<DateIdPair>> dataCache;
    private final String path;
    private final String storageKey;

    public LocalFileSystemStorage(Storage storage) {
        if (storage == null) {
            this.storageKey = null;
            this.dataCache = null;
            this.path = null;
        } else {
            this.storageKey = "local_file_system#" + storage.getKey();
            this.dataCache = new ExpiringCache<List<DateIdPair>>(this.storageKey);
            JSONObject data = storage.getConfig();
            this.path = data.getString("path");
        }
    }

    @Override
    public String getStorageTypeName() {
        return "local_file_system";
    }

    @Override
    public boolean needsApproval() {
        return false;
    }

    @Override
    public boolean isCloud() {
        return false;
    }

    @Override
    public byte[] getData(String identifier) {
        if (!StringUtil.isValidFilename(identifier)) {
            logger.log(Level.WARNING, "WARNING: someone tried to get file: \"" + identifier + "\"");
            return null;
        }
        return FileUtil.getFileAsByteArr(this.path + "/" + identifier);
    }

    @Override
    public List<ValueValuePair> getFileList(DatabaseConnector dbCon) {
        List<DateIdPair> fileList = this.getFileIdListByDates();
        ArrayList<ValueValuePair> retList = new ArrayList<ValueValuePair>();
        for (DateIdPair e : fileList) {
            retList.add(new StringStringPair(e.getId(), e.getId()));
        }
        return retList;
    }

    private Date getDateFromFile(File f) {
        try {
            return new Date(ResourceUtil.getCreationTime(f).toMillis());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<DateIdPair> getFileIdListByDates() {
        List<DateIdPair> fileList = this.dataCache.retrieve("");
        if (fileList == null) {
            File f = new File(this.path);
            fileList = new ArrayList<DateIdPair>();
            for (File f2 : f.listFiles()) {
                fileList.add(new DateIdPair(this.getDateFromFile(f2), f2.getName()));
            }
            Collections.sort(fileList, (p1, p2) -> p2.getDate().compareTo(p1.getDate()));
            this.dataCache.put("", fileList);
        }
        return fileList;
    }

    @Override
    public List<ValueValuePair> getFileListByDate(DatabaseConnector dbCon, Date from, Date to) {
        List<DateIdPair> fileList = this.getFileIdListByDates();
        ArrayList<ValueValuePair> retList = new ArrayList<ValueValuePair>();
        for (DateIdPair pair : fileList) {
            Date pairDate = pair.getDate();
            if (!pairDate.after(from) || !pairDate.before(to)) continue;
            retList.add(pair);
        }
        return retList;
    }

    @Override
    public List<StorageSearchEntry> searchForEntries(DatabaseConnector dbCon, String searchQuery) {
        List<ValueValuePair> pairList = this.getFileList(dbCon);
        ArrayList<StorageSearchEntry> retList = new ArrayList<StorageSearchEntry>();
        for (ValueValuePair pair : pairList) {
            byte[] data = this.getData(pair.getId());
            if (data != null) {
                retList.addAll(LocalFileSystemStorage.getSearchResult(pair.getId(), pair.getName(), searchQuery, new String(data)));
                continue;
            }
            logger.log(Level.WARNING, "file with id=\"" + pair.getId() + "\" does not exist!");
        }
        return retList;
    }

    @Override
    public List<StorageSearchEntry> searchForEntries(DatabaseConnector dbCon, String searchQuery, Date start, Date end) {
        List<ValueValuePair> pairList = this.getFileListByDate(dbCon, start, end);
        ArrayList<StorageSearchEntry> retList = new ArrayList<StorageSearchEntry>();
        for (ValueValuePair pair : pairList) {
            retList.addAll(LocalFileSystemStorage.getSearchResult(pair.getId(), pair.getName(), searchQuery, new String(this.getData(pair.getId()))));
        }
        return retList;
    }

    @Override
    public void pushIndex(DatabaseConnector dbCon, String identifier, String name, long timestamp, String clientIp) {
        throw new RuntimeException("Local File System storage cannot be pushed!");
    }
}

