/*
 * Decompiled with CFR 0.152.
 */
package co.clai.util;

import com.google.common.io.ByteStreams;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;

public class FileUtil {
    public static String getFileContentAsString(String filename) {
        return FileUtil.getFileContentAsString(new File(filename));
    }

    public static String getFileContentAsString(File file) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader b = new BufferedReader(new FileReader(file));){
            while (b.ready()) {
                sb.append(b.readLine() + "\n");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getFileAsByteArr(String string) {
        try (FileInputStream in = new FileInputStream(string);){
            byte[] byArray = ByteStreams.toByteArray((InputStream)in);
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

