/*
 * Decompiled with CFR 0.152.
 */
package co.clai.module;

import co.clai.AcpSession;
import co.clai.access.AccessibleFunctionHelper;
import co.clai.access.CommunityAsset;
import co.clai.access.GeneralAsset;
import co.clai.db.DatabaseConnector;
import co.clai.db.model.Community;
import co.clai.db.model.Template;
import co.clai.html.HtmlForm;
import co.clai.html.HtmlPage;
import co.clai.html.HtmlTable;
import co.clai.module.AbstractModule;
import co.clai.module.FunctionResult;
import co.clai.util.IntStringPair;
import co.clai.util.ValueValuePair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public class EditTemplate
extends AbstractModule {
    public static final String LOCATION = "editTemplate";
    public static final String TITLE = "Edit Templates";
    public static final String FUNCTION_NAME_ADD_TEMPLATE = "addTemplate";
    public static final String FUNCTION_NAME_COPY_TEMPLATE = "copyTemplate";
    public static final String FUNCTION_NAME_EDIT_TEMPLATE = "editTemplate";
    public static final String FUNCTION_NAME_DELETE_TEMPLATE = "deleteTemplate";
    private static final String GET_PARAM = "edit";

    public EditTemplate(DatabaseConnector dbCon) {
        super("editTemplate", dbCon);
    }

    @Override
    protected byte[] invokePlain(AcpSession s, Map<String, String[]> parameters) {
        HtmlPage p = new HtmlPage(this.dbCon, TITLE, null, null, null, s);
        p.writeH1(TITLE);
        HtmlTable ht = new HtmlTable();
        ht.addHeader(Arrays.asList("ID", "key", "name", "Community", "Edit", "Delete"));
        ht.startBody();
        List<Template> allTemplates = Template.getAllTemplates(this.dbCon);
        for (Template template : allTemplates) {
            if (!s.getThisUser().hasAccess(this.getAccessibleHelper(), new GeneralAsset(template.getId(), template.getCommunityId()))) continue;
            HtmlTable.HtmlTableRow htmlTableRow = new HtmlTable.HtmlTableRow(ht);
            htmlTableRow.writeText(template.getId() + "");
            htmlTableRow.writeText(template.getKey());
            htmlTableRow.writeText(template.getName());
            Community thisC = Community.getCommunityById(this.dbCon, template.getCommunityId());
            htmlTableRow.writeText(thisC == null ? "Unknown Community" : thisC.getName());
            HtmlForm editForm = new HtmlForm("editTemplate", HtmlForm.Method.GET);
            editForm.addHiddenElement(GET_PARAM, "true");
            editForm.addHiddenElement("id", template.getId() + "");
            editForm.addSubmit("Edit", HtmlForm.ButtonType.PRIMARY);
            htmlTableRow.write(editForm);
            if (s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_DELETE_TEMPLATE), template.getAsset())) {
                HtmlForm deleteForm = new HtmlForm("editTemplate.deleteTemplate", HtmlForm.Method.POST);
                deleteForm.addHiddenElement("id", template.getId() + "");
                deleteForm.addSubmit("Delete", HtmlForm.ButtonType.DANGER);
                htmlTableRow.write(deleteForm);
            }
            ht.write(htmlTableRow);
        }
        p.write(ht);
        if (parameters.get(GET_PARAM) == null || parameters.get(GET_PARAM).length == 0) {
            ArrayList<ValueValuePair> selectionCommunityValues;
            if (s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_ADD_TEMPLATE))) {
                p.writeH2("Add new Template:");
                selectionCommunityValues = new ArrayList<ValueValuePair>();
                if (s.getThisUser().getIsRoot()) {
                    selectionCommunityValues.add(new IntStringPair(0, "Community Wide"));
                }
                for (Community community : Community.getAllCommunity(this.dbCon)) {
                    if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_ADD_TEMPLATE), new CommunityAsset(community.getId()))) continue;
                    selectionCommunityValues.add(new IntStringPair(community.getId(), community.getName()));
                }
                HtmlForm htmlForm = new HtmlForm("editTemplate.addTemplate", HtmlForm.Method.POST);
                htmlForm.addTextElement("Name", "name", "");
                htmlForm.addTextElement("Key", "_key", "");
                htmlForm.addSelectionDropdown("Community ID", "community_id", selectionCommunityValues);
                htmlForm.addSubmit("Add new Template", HtmlForm.ButtonType.SUCCESS);
                p.write(htmlForm);
            }
            if (s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_COPY_TEMPLATE))) {
                p.writeH2("Copy Existing Template:");
                selectionCommunityValues = new ArrayList();
                if (s.getThisUser().getIsRoot()) {
                    selectionCommunityValues.add(new IntStringPair(0, "Community Wide"));
                }
                for (Community community : Community.getAllCommunity(this.dbCon)) {
                    if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_ADD_TEMPLATE), new CommunityAsset(community.getId()))) continue;
                    selectionCommunityValues.add(new IntStringPair(community.getId(), community.getName()));
                }
                ArrayList<ValueValuePair> arrayList = new ArrayList<ValueValuePair>();
                for (Template t : Template.getAllTemplates(this.dbCon)) {
                    if (t.getCommunityId() == 0) {
                        arrayList.add(new IntStringPair(t.getId(), t.getName()));
                        continue;
                    }
                    if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_COPY_TEMPLATE), t.getAsset())) continue;
                    arrayList.add(new IntStringPair(t.getId(), t.getName()));
                }
                HtmlForm htmlForm = new HtmlForm("editTemplate.copyTemplate", HtmlForm.Method.POST);
                htmlForm.addTextElement("Name", "name", "");
                htmlForm.addTextElement("Key", "_key", "");
                htmlForm.addSelectionDropdown("Community ID", "community_id", selectionCommunityValues);
                htmlForm.addSelectionDropdown("Copy from Template", "id", arrayList);
                htmlForm.addSubmit("Add new Template", HtmlForm.ButtonType.SUCCESS);
                p.write(htmlForm);
            }
        } else {
            p.writeHline();
            Template t = Template.getTemplateById(this.dbCon, Integer.parseInt(parameters.get("id")[0]));
            if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), "editTemplate"), t.getAsset())) {
                p.writeText("no access");
                return p.finish().getBytes();
            }
            p.writeH1("Edit Template " + t.getName());
            HtmlForm htmlForm = new HtmlForm("editTemplate.editTemplate", HtmlForm.Method.POST);
            htmlForm.addHiddenElement("id", t.getId() + "");
            htmlForm.addTextArea("data", new String(t.getData()), 20, 120);
            htmlForm.addSubmit("Change Template", HtmlForm.ButtonType.WARNING);
            p.write(htmlForm);
        }
        return p.finish().getBytes();
    }

    @Override
    protected Map<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>> loadFunctions() {
        HashMap<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>> retMap = new HashMap<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>>();
        retMap.put(FUNCTION_NAME_ADD_TEMPLATE, this::addTemplate);
        retMap.put(FUNCTION_NAME_COPY_TEMPLATE, this::copyTemplate);
        retMap.put("editTemplate", this::editTemplate);
        retMap.put(FUNCTION_NAME_DELETE_TEMPLATE, this::deleteTemplate);
        return retMap;
    }

    private FunctionResult addTemplate(AcpSession s, Map<String, String[]> parameters) {
        String templateName = parameters.get("name")[0];
        String key = parameters.get("_key")[0];
        int communityId = Integer.parseInt(parameters.get("community_id")[0]);
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_ADD_TEMPLATE), new CommunityAsset(communityId))) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, "editTemplate");
        }
        Template.addNewTemplate(this.dbCon, templateName, key, communityId);
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, "editTemplate");
        r.getBuilder().addParameter(GET_PARAM, "true");
        r.getBuilder().addParameter("id", Template.getTemplateByKey(this.dbCon, key).getId() + "");
        return r;
    }

    private FunctionResult copyTemplate(AcpSession s, Map<String, String[]> parameters) {
        int id = Integer.parseInt(parameters.get("id")[0]);
        String templateName = parameters.get("name")[0];
        String key = parameters.get("_key")[0];
        int communityId = Integer.parseInt(parameters.get("community_id")[0]);
        Template t = Template.getTemplateById(this.dbCon, id);
        if (t.getCommunityId() != 0 && !s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), "editTemplate"), t.getAsset())) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, "editTemplate");
        }
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_ADD_TEMPLATE), new CommunityAsset(communityId))) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, "editTemplate");
        }
        byte[] data = t.getData();
        Template.addNewTemplate(this.dbCon, templateName, key, communityId);
        Template newTemplate = Template.getTemplateByKey(this.dbCon, key);
        newTemplate.edit(this.dbCon, new String(data));
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, "editTemplate");
        r.getBuilder().addParameter(GET_PARAM, "true");
        r.getBuilder().addParameter("id", newTemplate.getId() + "");
        return r;
    }

    private FunctionResult editTemplate(AcpSession s, Map<String, String[]> parameters) {
        int id = Integer.parseInt(parameters.get("id")[0]);
        Template t = Template.getTemplateById(this.dbCon, id);
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), "editTemplate"), t.getAsset())) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, "editTemplate");
        }
        String data = parameters.get("data")[0];
        t.edit(this.dbCon, data);
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, "editTemplate");
        r.getBuilder().addParameter(GET_PARAM, "true");
        r.getBuilder().addParameter("id", id + "");
        return r;
    }

    private FunctionResult deleteTemplate(AcpSession s, Map<String, String[]> parameters) {
        int id = Integer.parseInt(parameters.get("id")[0]);
        Template t = Template.getTemplateById(this.dbCon, id);
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), "editTemplate"), t.getAsset())) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, "editTemplate");
        }
        t.delete(this.dbCon);
        return new FunctionResult(FunctionResult.Status.OK, "editTemplate");
    }
}

