/*
 * Decompiled with CFR 0.152.
 */
package co.clai.remote;

import co.clai.db.DatabaseConnector;
import co.clai.db.model.Location;
import co.clai.db.model.User;
import co.clai.remote.AbstractCachedQueryConnection;
import co.clai.remote.OAuth2Helper;
import co.clai.remote.RemoteUserData;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.json.JSONObject;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public abstract class AbstractRemoteConnection
extends AbstractCachedQueryConnection {
    public static final String REMOTE_LOCATION_CONFIG_KEY_TYPE = "type";
    public static final String UNIQUE_ID_KEY = "uniqueId";
    protected static final String JSON_KEY_ALLOW_PW_LOGIN = "allowPwLogin";
    private static final Map<String, Class<? extends AbstractRemoteConnection>> allRemoteTypes = AbstractRemoteConnection.loadRemoteTypes();
    private static final Map<String, JSONObject> defaultConfig = AbstractRemoteConnection.loadDefaultTypes();

    private static Map<String, Class<? extends AbstractRemoteConnection>> loadRemoteTypes() {
        HashMap<String, Class<? extends AbstractRemoteConnection>> reMap = new HashMap<String, Class<? extends AbstractRemoteConnection>>();
        Reflections reflections = new Reflections("co.clai.remote", new Scanner[0]);
        Set allClasses = reflections.getSubTypesOf(AbstractRemoteConnection.class);
        for (Class c : allClasses) {
            String name = null;
            try {
                Constructor cons = c.getConstructor(Location.class);
                AbstractRemoteConnection r = (AbstractRemoteConnection)cons.newInstance(new Object[]{null});
                name = r.getRemoteTypeName();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            logger.log(Level.INFO, "loading remote Location " + name + ", " + c.getName());
            reMap.put(name, c);
        }
        return reMap;
    }

    private static Map<String, JSONObject> loadDefaultTypes() {
        HashMap<String, JSONObject> retMap = new HashMap<String, JSONObject>();
        Reflections reflections = new Reflections("co.clai.remote", new Scanner[0]);
        Set allClasses = reflections.getSubTypesOf(AbstractRemoteConnection.class);
        for (Class c : allClasses) {
            JSONObject defConfig;
            String name = null;
            try {
                Constructor cons = c.getConstructor(Location.class);
                AbstractRemoteConnection r = (AbstractRemoteConnection)cons.newInstance(new Object[]{null});
                name = r.getRemoteTypeName();
                defConfig = r.getDefaultConfig();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            logger.log(Level.INFO, "loading Default Location config " + name + ", " + c.getName());
            retMap.put(name, defConfig);
        }
        return retMap;
    }

    public static AbstractRemoteConnection getRemoteFromLocation(Location l) {
        Class<? extends AbstractRemoteConnection> c = allRemoteTypes.get(l.getConfig().getString(REMOTE_LOCATION_CONFIG_KEY_TYPE));
        try {
            Constructor<? extends AbstractRemoteConnection> cons = c.getConstructor(Location.class);
            return cons.newInstance(l);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "error while creating RemoteConnection", e);
            return null;
        }
    }

    public static List<String> getAllTypes() {
        ArrayList<String> retList = new ArrayList<String>();
        retList.addAll(allRemoteTypes.keySet());
        return retList;
    }

    public static String getDefaultConfig(String type) {
        return defaultConfig.get(type).toString();
    }

    protected abstract String getRemoteTypeName();

    public abstract RemoteUserData getUserDataByUserId(int var1);

    public abstract List<Integer> getUserIdsFromUserGroup(int var1);

    public abstract String getUserFieldContentFromUserId(String var1, int var2);

    public abstract RemoteUserData getUserDataByUserName(String var1);

    public abstract RemoteUserData getUserDataByUserEmail(String var1);

    public abstract int loginUser(String var1, String var2);

    public abstract List<Integer> getUsergroupsFromUserId(int var1);

    public abstract String getUsergroupNameById(int var1);

    public abstract JSONObject getDefaultConfig();

    public abstract JSONObject getConfig();

    public abstract boolean canDoPasswordLogin();

    public abstract boolean canDoOAuth2Login();

    public abstract OAuth2Helper.OAuth2Data getOAuth2Data();

    public abstract User getUserWithOAuth2Code(DatabaseConnector var1, Map<String, String[]> var2, int var3);
}

