/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.x.io;

import com.mysql.cj.api.x.core.Warning;
import com.mysql.cj.api.x.io.MessageReader;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.x.core.CoreWarning;
import com.mysql.cj.x.core.StatementExecuteOk;
import com.mysql.cj.x.protobuf.MysqlxNotice;
import java.util.ArrayList;
import java.util.List;

public class StatementExecuteOkBuilder {
    private long rowsAffected = 0L;
    private Long lastInsertId = null;
    private List<Warning> warnings = new ArrayList<Warning>();

    public void addNotice(MysqlxNotice.Frame notice) {
        if (notice.getType() == 1) {
            this.warnings.add(new CoreWarning(MessageReader.parseNotice(notice.getPayload(), MysqlxNotice.Warning.class)));
        } else if (notice.getType() == 3) {
            MysqlxNotice.SessionStateChanged changeMsg = MessageReader.parseNotice(notice.getPayload(), MysqlxNotice.SessionStateChanged.class);
            switch (changeMsg.getParam()) {
                case GENERATED_INSERT_ID: {
                    this.lastInsertId = changeMsg.getValue().getVUnsignedInt();
                    break;
                }
                case ROWS_AFFECTED: {
                    this.rowsAffected = changeMsg.getValue().getVUnsignedInt();
                    break;
                }
                case PRODUCED_MESSAGE: {
                    break;
                }
                default: {
                    new WrongArgumentException("unhandled SessionStateChanged notice! " + notice).printStackTrace();
                    break;
                }
            }
        } else {
            new WrongArgumentException("Got an unknown notice: " + notice).printStackTrace();
        }
    }

    public StatementExecuteOk build() {
        return new StatementExecuteOk(this.rowsAffected, this.lastInsertId, this.warnings);
    }
}

