/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.xdevapi;

import com.mysql.cj.api.xdevapi.PersistenceHandler;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.core.util.Util;
import com.mysql.cj.xdevapi.DbDoc;
import com.mysql.cj.xdevapi.JsonParser;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultPersistenceHandler
implements PersistenceHandler {
    private final Path systemWidePath;
    private final Path userWidePath;

    public DefaultPersistenceHandler() {
        if (Util.isRunningOnWindows()) {
            this.systemWidePath = Paths.get(System.getenv("PROGRAMDATA"), "MySQL", "sessions.json");
            this.userWidePath = Paths.get(System.getenv("APPDATA"), "MySQL", "sessions.json");
        } else {
            this.systemWidePath = Paths.get("/etc/mysql", "sessions.json");
            this.userWidePath = Paths.get(System.getProperty("user.home"), ".mysql", "sessions.json");
        }
    }

    public DefaultPersistenceHandler(String systemWidePath, String userWidePath) {
        this.systemWidePath = Paths.get(systemWidePath, new String[0]);
        this.userWidePath = Paths.get(userWidePath, new String[0]);
    }

    @Override
    public void save(String name, DbDoc data) {
        DbDoc persistentData = this.loadPersistentData(this.userWidePath);
        persistentData.put(name, data);
        this.saveUserWidePersistentData(persistentData);
    }

    @Override
    public DbDoc load(String name) {
        DbDoc persistentData = this.loadPersistentData();
        if (!persistentData.containsKey(name)) {
            throw ExceptionFactory.createException("Key '" + name + "' was not found in the persistent data.");
        }
        return (DbDoc)persistentData.get(name);
    }

    @Override
    public boolean delete(String name) {
        DbDoc persistentData = this.loadPersistentData(this.userWidePath);
        boolean deleted = persistentData.remove(name) != null;
        this.saveUserWidePersistentData(persistentData);
        return deleted;
    }

    @Override
    public List<String> list() {
        DbDoc persistentData = this.loadPersistentData();
        List<String> keys = Collections.unmodifiableList(persistentData.keySet().stream().collect(Collectors.toList()));
        return keys;
    }

    @Override
    public boolean exists(String name) {
        DbDoc persistentData = this.loadPersistentData();
        return persistentData.containsKey(name);
    }

    private synchronized DbDoc loadPersistentData() {
        DbDoc sysPersistentData = this.loadPersistentData(this.systemWidePath);
        DbDoc userPersistentData = this.loadPersistentData(this.userWidePath);
        DbDoc persistentData = Stream.concat(sysPersistentData.entrySet().stream(), userPersistentData.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (o, n) -> n, DbDoc::new));
        return persistentData;
    }

    private synchronized DbDoc loadPersistentData(Path path) {
        String jsonString = this.readFileToString(path);
        if (StringUtils.isEmptyOrWhitespaceOnly(jsonString)) {
            return new DbDoc();
        }
        try {
            return JsonParser.parseDoc(new StringReader(jsonString));
        }
        catch (IOException e) {
            throw ExceptionFactory.createException("Failed parsing the JSon data from file '" + path + "'.", e);
        }
    }

    private synchronized String readFileToString(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                byte[] bytes = Files.readAllBytes(path);
                return new String(bytes);
            }
            catch (IOException e) {
                throw ExceptionFactory.createException("Error reading from file '" + path + "'.", e);
            }
        }
        return "";
    }

    private synchronized void saveUserWidePersistentData(DbDoc data) {
        if (Files.exists(this.userWidePath, new LinkOption[0]) && !Files.isWritable(this.userWidePath)) {
            throw ExceptionFactory.createException("Cannot write to file '" + this.userWidePath + "'.");
        }
        try {
            Path parent = this.userWidePath.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.write(this.userWidePath, data.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw ExceptionFactory.createException("Error writing to file '" + this.userWidePath + "'.", e);
        }
    }
}

