/*
 * Decompiled with CFR 0.152.
 */
package co.clai.db;

import co.clai.MainHttpListener;
import co.clai.db.DbUtil;
import co.clai.db.DbValue;
import co.clai.db.DbValueType;
import co.clai.db.model.Game;
import co.clai.util.log.LoggingUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class DatabaseConnector {
    private final String dbPath;
    private final String dbUser;
    private final String dbPassword;
    private final MainHttpListener listener;
    private final Logger logger = LoggingUtil.getDefaultLogger();

    public DatabaseConnector(MainHttpListener listener, JSONObject dbConfig) {
        this.dbPath = dbConfig.getString("path");
        this.dbUser = dbConfig.getString("username");
        this.dbPassword = dbConfig.getString("password");
        this.listener = listener;
    }

    private Connection openConnection() throws SQLException {
        return DriverManager.getConnection(this.dbPath, this.dbUser, this.dbPassword);
    }

    public void executeUpdatePreparedQuery(List<DbValue> values, String preparedStatementString) {
        try (Connection con = this.openConnection();
             PreparedStatement stmt = con.prepareStatement(preparedStatementString);){
            DatabaseConnector.addParametersToStatement(values, stmt, con);
            this.logger.log(Level.INFO, stmt.toString());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void insert(String dbName, List<String> columns, List<DbValue> values) {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO " + dbName + " (");
        sb.append(DatabaseConnector.generateCommaSeperatedList(columns));
        sb.append(") VALUES (");
        sb.append(DatabaseConnector.generateCommaSeperatedQuestionMarks(values.size()));
        sb.append(")");
        this.executeUpdatePreparedQuery(values, sb.toString());
    }

    public List<Map<String, DbValue>> select(String dbName, Map<String, DbValueType> returnTypes) {
        return this.select(dbName, Arrays.asList(new String[0]), Arrays.asList(new DbValue[0]), returnTypes);
    }

    public List<Map<String, DbValue>> select(String dbName, String columns, DbValue selector, Map<String, DbValueType> returnTypes) {
        return this.select(dbName, Arrays.asList(columns), Arrays.asList(selector), returnTypes);
    }

    public List<Map<String, DbValue>> select(String dbName, List<String> columns, List<DbValue> selector, Map<String, DbValueType> returnTypes) {
        return this.select(dbName, columns, selector, returnTypes, "");
    }

    public List<Map<String, DbValue>> select(String dbName, String columns, DbValue selector, Map<String, DbValueType> returnTypes, String append) {
        return this.select(dbName, Arrays.asList(columns), Arrays.asList(selector), returnTypes, append);
    }

    public List<Map<String, DbValue>> select(String dbName, List<String> columns, List<DbValue> selector, Map<String, DbValueType> returnTypes, String append) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * FROM " + dbName + " WHERE ");
        for (String c : columns) {
            sb.append(c + " = ? AND ");
        }
        sb.append(" TRUE " + (append == null ? "" : append) + " ;");
        ArrayList<Map<String, DbValue>> retList = new ArrayList<Map<String, DbValue>>();
        try (Connection con = this.openConnection();
             PreparedStatement stmt = con.prepareStatement(sb.toString());){
            DatabaseConnector.addParametersToStatement(selector, stmt, con);
            this.logger.log(Level.INFO, stmt.toString());
            try (ResultSet rs = stmt.executeQuery();){
                ResultSetMetaData rsmd = rs.getMetaData();
                HashMap<String, Integer> columnIdMap = new HashMap<String, Integer>();
                for (int j = 1; j < rsmd.getColumnCount() + 1; ++j) {
                    columnIdMap.put(rsmd.getColumnName(j), new Integer(j));
                }
                while (rs.next()) {
                    HashMap<String, DbValue> tmpMap = new HashMap<String, DbValue>();
                    block41: for (Map.Entry<String, DbValueType> e : returnTypes.entrySet()) {
                        int columnNumber = (Integer)columnIdMap.get(e.getKey());
                        switch (e.getValue()) {
                            case BLOB: {
                                tmpMap.put(e.getKey(), new DbValue(rs.getBlob(columnNumber)));
                                continue block41;
                            }
                            case STRING: {
                                tmpMap.put(e.getKey(), new DbValue(rs.getString(columnNumber)));
                                continue block41;
                            }
                            case INTEGER: {
                                tmpMap.put(e.getKey(), new DbValue(rs.getInt(columnNumber)));
                                continue block41;
                            }
                            case REAL: {
                                tmpMap.put(e.getKey(), new DbValue(rs.getDouble(columnNumber)));
                                continue block41;
                            }
                            case TIMESTAMP: {
                                tmpMap.put(e.getKey(), new DbValue(new Timestamp(rs.getLong(columnNumber))));
                                continue block41;
                            }
                        }
                        throw new RuntimeException("unknown value type in DatabaseConnector::executePreparedQuery");
                    }
                    retList.add(tmpMap);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return retList;
    }

    private static void addParametersToStatement(List<DbValue> selector, PreparedStatement stmt, Connection con) throws SQLException {
        int i = 1;
        for (DbValue v : selector) {
            switch (v.getDbValueType()) {
                case BLOB: {
                    stmt.setBlob(i, v.getBlob(con));
                    break;
                }
                case STRING: {
                    stmt.setString(i, v.getString());
                    break;
                }
                case INTEGER: {
                    stmt.setInt(i, v.getInt());
                    break;
                }
                case REAL: {
                    stmt.setDouble(i, v.getDouble());
                    break;
                }
                case TIMESTAMP: {
                    stmt.setLong(i, v.getTimestamp().getTime());
                    break;
                }
                default: {
                    throw new RuntimeException("unknown value type in DatabaseConnector::executePreparedQuery");
                }
            }
            ++i;
        }
    }

    private static String generateCommaSeperatedList(List<String> columns) {
        StringJoiner sj = new StringJoiner(",");
        for (String c : columns) {
            sj.add(c);
        }
        return sj.toString();
    }

    private static String generateCommaSeperatedQuestionMarks(int size) {
        StringJoiner sj = new StringJoiner(",");
        for (int i = 0; i < size; ++i) {
            sj.add("?");
        }
        return sj.toString();
    }

    public void updateValue(String tableName, List<String> valueColumns, List<DbValue> valueValues, String selectorColumns, DbValue selectorIds) {
        this.updateValue(tableName, valueColumns, valueValues, Arrays.asList(selectorColumns), Arrays.asList(selectorIds));
    }

    public void updateValue(String tableName, List<String> valueColumns, List<DbValue> valueValues, List<String> selectorColumns, List<DbValue> selectorIds) {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE " + tableName + " SET ");
        StringJoiner sj = new StringJoiner(" , ");
        for (String c : valueColumns) {
            sj = sj.add(c + " = ?");
        }
        sb.append(sj.toString());
        sb.append(" WHERE ");
        for (String c : selectorColumns) {
            sb.append(c + " = ? AND ");
        }
        sb.append(" TRUE;");
        String query = sb.toString();
        try (Connection con = this.openConnection();
             PreparedStatement stmt = con.prepareStatement(query);){
            ArrayList<DbValue> allParams = new ArrayList<DbValue>();
            allParams.addAll(valueValues);
            allParams.addAll(selectorIds);
            DatabaseConnector.addParametersToStatement(allParams, stmt, con);
            this.logger.log(Level.INFO, stmt.toString());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteFrom(String tableName, String selectorColumn, DbValue selectorIds) {
        this.deleteFrom(tableName, Arrays.asList(selectorColumn), Arrays.asList(selectorIds));
    }

    public void deleteFrom(String tableName, List<String> selectorColumns, List<DbValue> selectorIds) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM " + tableName + " WHERE ");
        for (String c : selectorColumns) {
            sb.append(c + " = ? AND ");
        }
        sb.append(" TRUE;");
        String query = sb.toString();
        try (Connection con = this.openConnection();
             PreparedStatement stmt = con.prepareStatement(query);){
            DatabaseConnector.addParametersToStatement(selectorIds, stmt, con);
            this.logger.log(Level.INFO, stmt.toString());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public MainHttpListener getListener() {
        return this.listener;
    }

    public static void initializeDatabase(DatabaseConnector dbCon) {
        DbUtil.createAllTables(dbCon);
        Game.populateGameTable(dbCon);
    }
}

