/*
 * Decompiled with CFR 0.152.
 */
package co.clai.db.model;

import co.clai.db.DatabaseConnector;
import co.clai.db.DbValue;
import co.clai.db.DbValueType;
import co.clai.util.log.LoggingUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;

public abstract class AbstractDbTable {
    private final String tableName;
    private final Map<String, DbValueType> columns;
    protected final Logger logger;

    public AbstractDbTable(String tableName, Map<String, DbValueType> columns) {
        this.tableName = tableName;
        this.columns = columns;
        this.logger = LoggingUtil.getDefaultLogger();
    }

    public String getTableName() {
        return this.tableName;
    }

    public Map<String, DbValueType> getColumns() {
        return this.columns;
    }

    public static void createTable(DatabaseConnector dbCon, AbstractDbTable t) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE " + t.getTableName() + " ( ");
        block7: for (Map.Entry<String, DbValueType> e : t.getColumns().entrySet()) {
            switch (e.getValue()) {
                case STRING: {
                    sb.append(e.getKey() + " VARCHAR(8192), ");
                    continue block7;
                }
                case BLOB: {
                    sb.append(e.getKey() + " BLOB, ");
                    continue block7;
                }
                case INTEGER: {
                    sb.append(e.getKey() + " INTEGER, ");
                    continue block7;
                }
                case REAL: {
                    sb.append(e.getKey() + " REAL, ");
                    continue block7;
                }
                case TIMESTAMP: {
                    sb.append(e.getKey() + " LONG, ");
                    continue block7;
                }
            }
            throw new RuntimeException("unknown value type in AbstractDbTable::createTable");
        }
        sb.append(" PRIMARY KEY ( id ));");
        dbCon.executeUpdatePreparedQuery(new ArrayList<DbValue>(), sb.toString());
        dbCon.executeUpdatePreparedQuery(new ArrayList<DbValue>(), "ALTER TABLE " + t.getTableName() + " MODIFY COLUMN id INT auto_increment");
    }
}

