/*
 * Decompiled with CFR 0.152.
 */
package co.clai.html;

import co.clai.html.Builder;

public abstract class AbstractRenderer
implements Builder {
    private StringBuilder buffer = new StringBuilder();

    public AbstractRenderer(String begin) {
        this.buffer.append(begin);
    }

    protected static final String appendCssIdClassIfNotNull(String cssId, String cssClass) {
        return (cssId == null ? " " : " id='" + cssId + "' ") + (cssClass == null ? " " : " class='" + cssClass + "' ");
    }

    protected final void appendData(String data) {
        this.buffer.append(data + "\n");
    }

    @Override
    public final void writeWithoutEscaping(String data) {
        this.appendData(data);
    }

    @Override
    public String finish() {
        return this.buffer.toString();
    }

    public void writeH1(String string) {
        this.appendData("<h1>" + Builder.escapeForHtml(string) + "</h1>");
    }

    public void writeH2(String string) {
        this.appendData("<h2>" + Builder.escapeForHtml(string) + "</h2>");
    }

    public void writeH3(String string) {
        this.appendData("<h3>" + Builder.escapeForHtml(string) + "</h3>");
    }

    public void writeHline() {
        this.appendData("<hr>");
    }

    public void writeText(String string) {
        this.appendData(Builder.escapeForHtml(string));
    }

    public void writeLink(String location, String text) {
        this.appendData("<a href='" + location + "'>" + Builder.escapeForHtml(text) + "</a>");
    }
}

