/*
 * Decompiled with CFR 0.152.
 */
package co.clai.module;

import co.clai.AcpSession;
import co.clai.access.AccessibleFunctionHelper;
import co.clai.access.AccessibleModuleHelper;
import co.clai.db.DatabaseConnector;
import co.clai.db.model.Ban;
import co.clai.db.model.Banlist;
import co.clai.db.model.Community;
import co.clai.db.model.Game;
import co.clai.html.Builder;
import co.clai.html.HtmlForm;
import co.clai.html.HtmlPage;
import co.clai.html.HtmlTable;
import co.clai.module.AbstractModule;
import co.clai.module.FunctionResult;
import co.clai.util.StringStringPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.logging.Level;
import org.json.JSONArray;
import org.json.JSONObject;

public class EditBanlist
extends AbstractModule {
    private static final String GET_PARAM_PERMABAN = "permaban";
    private static final String GET_PREFIX_EXTRA_INFO = "extra_info_";
    public static final String LOCATION = "banlist";
    public static final String TITLE = "Ban and unban people";
    public static final String FUNCTION_NAME_ADD_BAN = "addBan";
    public static final String FUNCTION_NAME_EDIT_BAN = "editBan";
    public static final String FUNCTION_NAME_UNBAN = "unban";
    public static final String FUNCTION_NAME_ADD_BANLIST = "addBanlist";
    public static final String FUNCTION_NAME_EDIT_BANLIST = "editBanlist";
    public static final String FUNCTION_NAME_REMOVE_BANLIST = "removeBanlist";
    private static final String GET_KEY = "edit";
    private static final String FUNCTION_NAME_EDIT_USER = "editUser";

    public EditBanlist(DatabaseConnector dbCon) {
        super(LOCATION, dbCon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] invokePlain(AcpSession s, Map<String, String[]> parameters) {
        HtmlPage p = new HtmlPage(this.dbCon, TITLE, null, null, null, s);
        if (parameters.get(GET_KEY) == null || parameters.get(GET_KEY).length == 0) {
            p.writeH1("Edit Banlist");
            List<Banlist> banlists = Banlist.getAllBanlists(this.dbCon);
            HtmlTable t = new HtmlTable();
            t.addHeader(Arrays.asList("id", "key", "name", "game", "community", "edit banned user", "edit banlist settings"));
            t.startBody();
            for (Banlist banl : banlists) {
                if (!s.getThisUser().hasAccess(new AccessibleModuleHelper(this.getModuleName()), banl.getAsset())) continue;
                HtmlTable.HtmlTableRow r = t.new HtmlTable.HtmlTableRow();
                r.writeText(banl.getId() + "");
                r.writeText(banl.getKey());
                r.writeText(banl.getName());
                String gameName = "";
                try {
                    Game g = Game.getGameById(this.dbCon, banl.getGameId());
                    gameName = g.getName();
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Error while creating game by id " + banl.getId() + ": " + e.getMessage(), e);
                    gameName = "unknown";
                }
                finally {
                    r.writeText(gameName);
                }
                String communityName = "";
                try {
                    Community c = Community.getCommunityById(this.dbCon, banl.getCommunityId());
                    communityName = c.getName();
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Error while creating community by id " + banl.getCommunityId() + ": " + e.getMessage(), e);
                    communityName = "unknown";
                }
                finally {
                    r.writeText(communityName);
                }
                HtmlForm f = new HtmlForm(LOCATION, HtmlForm.Method.GET);
                f.addHiddenElement(GET_KEY, FUNCTION_NAME_EDIT_BAN);
                f.addHiddenElement("id", banl.getId() + "");
                f.addSubmit("Edit User", HtmlForm.ButtonType.WARNING);
                r.write(f);
                if (s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_EDIT_BANLIST), banl.getAsset())) {
                    HtmlForm f2 = new HtmlForm(LOCATION, HtmlForm.Method.GET);
                    f2.addHiddenElement(GET_KEY, FUNCTION_NAME_EDIT_BANLIST);
                    f2.addHiddenElement("id", banl.getId() + "");
                    f2.addSubmit("Edit Banlist", HtmlForm.ButtonType.WARNING);
                    r.write(f2);
                }
                t.write(r);
            }
            p.write(t);
            if (s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_ADD_BANLIST))) {
                p.writeHline();
                p.writeH2("Add new Banlist:");
                HtmlForm addBanlistForm = new HtmlForm("banlist.addBanlist", HtmlForm.Method.POST);
                addBanlistForm.addTextElement("Key", "_key", "");
                addBanlistForm.addTextElement("Name", "name", "");
                addBanlistForm.addSelectionDropdown("Game", "game_id", Game.getGameListSelection(this.dbCon));
                addBanlistForm.addSelectionDropdown("Community", "community_id", Community.getCommunityListSelection(this.dbCon, s.getThisUser(), new AccessibleFunctionHelper(LOCATION, FUNCTION_NAME_ADD_BANLIST)));
                addBanlistForm.addSubmit("Add new Banlist", HtmlForm.ButtonType.SUCCESS);
                p.write(addBanlistForm);
            }
        } else {
            boolean editUser = false;
            Banlist list = null;
            switch (parameters.get(GET_KEY)[0]) {
                case "editBanlist": {
                    Banlist b = Banlist.getBanlistById(this.dbCon, Integer.parseInt(parameters.get("id")[0]));
                    p.writeH1("Edit " + b.getName());
                    HtmlForm editBanlistForm = new HtmlForm(this.getModuleName() + "." + FUNCTION_NAME_EDIT_BANLIST, HtmlForm.Method.POST);
                    editBanlistForm.addHiddenElement("id", b.getId() + "");
                    editBanlistForm.addTextElement("Key", "_key", b.getKey());
                    editBanlistForm.addTextElement("Name", "name", b.getName());
                    editBanlistForm.addSelectionDropdown("Game", "game_id", Game.getGameListSelection(this.dbCon), b.getGameId() + "");
                    editBanlistForm.addSelectionDropdown("Community", "community_id", Community.getCommunityListSelection(this.dbCon, s.getThisUser(), new AccessibleFunctionHelper(LOCATION, FUNCTION_NAME_ADD_BANLIST)), b.getCommunityId() + "");
                    String infoColumnsData = b.getInfoColumnsRaw();
                    try {
                        infoColumnsData = new JSONArray(b.getInfoColumnsRaw()).toString(4);
                    }
                    catch (Exception e) {
                        this.logger.log(Level.WARNING, "Failed to parse banlist info columns for banlist with id " + b.getId() + ": " + e.getMessage());
                    }
                    editBanlistForm.addTextArea("info_columns", infoColumnsData, 20, 50);
                    editBanlistForm.addSubmit("Edit Banlist", HtmlForm.ButtonType.WARNING);
                    p.write(editBanlistForm);
                    if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_REMOVE_BANLIST))) break;
                    p.writeHline();
                    p.writeH2("Remove Banlist:");
                    HtmlForm removeBanlistForm = new HtmlForm("banlist.removeBanlist", HtmlForm.Method.POST);
                    removeBanlistForm.addHiddenElement("id", b.getId() + "");
                    removeBanlistForm.addSubmit("Remove Banlist", HtmlForm.ButtonType.DANGER);
                    p.write(removeBanlistForm);
                    break;
                }
                case "editUser": {
                    int banId = Integer.parseInt(parameters.get("id")[0]);
                    Ban b = Ban.getBanById(this.dbCon, banId);
                    list = Banlist.getBanlistById(this.dbCon, b.getBanlistId());
                    p.writeH1("Ban and unban player");
                    p.writeH2("Edit ban:");
                    HtmlForm f = new HtmlForm(this.getModuleName() + "." + FUNCTION_NAME_EDIT_BAN, HtmlForm.Method.POST);
                    f.addHiddenElement("id", b.getId() + "");
                    f.addTextElement("Hash", "hash", b.getHash());
                    f.addTextElement("Start", "start", Ban.DEFAULT_TIME_FORMAT.format(b.getStart()));
                    f.addTextElement("End", "end", b.getEnd() == null ? "" : Ban.DEFAULT_TIME_FORMAT.format(b.getEnd()));
                    f.addCheckbox("Permaban", GET_PARAM_PERMABAN, "1", b.isPermaBan());
                    for (StringStringPair field : list.getInfoColumns()) {
                        f.addTextElement(field.getName(), GET_PREFIX_EXTRA_INFO + field.getId(), b.getInfo(field.getId()));
                    }
                    f.addSubmit("Edit Ban", HtmlForm.ButtonType.WARNING);
                    p.write(f);
                    editUser = true;
                }
                case "editBan": {
                    Object editBanLink;
                    String thisInfo;
                    String thisId;
                    HtmlTable.HtmlTableRow row;
                    Banlist bList = editUser ? list : Banlist.getBanlistById(this.dbCon, Integer.parseInt(parameters.get("id")[0]));
                    if (bList == null) {
                        throw new RuntimeException("This should not happen! EditBanlist::case FUNCTION_NAME_EDIT_BAN");
                    }
                    if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_EDIT_BAN), bList.getAsset())) {
                        p.writeText("No Access");
                        return p.finish().getBytes();
                    }
                    if (!editUser) {
                        p.writeH1("Ban and unban player");
                        p.writeH2("Add new Ban");
                        HtmlForm f = new HtmlForm(this.getModuleName() + "." + FUNCTION_NAME_ADD_BAN, HtmlForm.Method.POST);
                        f.addHiddenElement("banlist_id", bList.getId() + "");
                        f.addTextElement("Hash", "hash", "");
                        f.addTextElement("Start", "start", Ban.DEFAULT_TIME_FORMAT.format(new Date(System.currentTimeMillis())));
                        f.addTextElement("End", "end", Ban.DEFAULT_TIME_FORMAT.format(new Date(System.currentTimeMillis())));
                        f.addCheckbox("Permaban", GET_PARAM_PERMABAN, "1");
                        for (StringStringPair field : bList.getInfoColumns()) {
                            f.addTextElement(field.getName(), GET_PREFIX_EXTRA_INFO + field.getId(), "");
                        }
                        f.addSubmit("Add Ban", HtmlForm.ButtonType.DANGER);
                        p.write(f);
                    }
                    p.writeH2("Existing Bans");
                    HtmlTable ht = new HtmlTable();
                    ArrayList<String> header = new ArrayList<String>();
                    header.addAll(Arrays.asList("id", "hash", "start", "end", GET_PARAM_PERMABAN));
                    ArrayList<StringStringPair> extraColumns = new ArrayList<StringStringPair>();
                    Set<String> isLink = bList.getInfoColumnLinks();
                    try {
                        extraColumns.addAll(bList.getInfoColumns());
                        for (StringStringPair l : extraColumns) {
                            header.add(l.getName());
                        }
                    }
                    catch (Exception e) {
                        this.logger.log(Level.SEVERE, "Cannot instanciate info columns: " + e.getMessage(), e);
                    }
                    header.addAll(Arrays.asList("Edit", "Unban"));
                    ht.addHeader(header);
                    ht.startBody();
                    ArrayList<Ban> expiredBans = new ArrayList<Ban>();
                    for (Ban b : Ban.getBansFromBanlistId(this.dbCon, bList.getId())) {
                        if (b.isExpired()) {
                            expiredBans.add(b);
                            continue;
                        }
                        row = ht.new HtmlTable.HtmlTableRow();
                        row.writeText(b.getId() + "");
                        row.writeText(b.getHash());
                        row.writeText(Ban.DEFAULT_TIME_FORMAT.format(b.getStart()));
                        if (b.isPermaBan()) {
                            row.writeText("---");
                            row.writeText("x");
                        } else {
                            row.writeText(Ban.DEFAULT_TIME_FORMAT.format(b.getEnd()));
                            row.writeText("");
                        }
                        try {
                            for (StringStringPair l : extraColumns) {
                                thisId = l.getId();
                                thisInfo = b.getInfo(thisId);
                                if (isLink.contains(thisId)) {
                                    if ("".equals(thisInfo)) {
                                        row.writeText(thisInfo);
                                        continue;
                                    }
                                    row.writeLink(thisInfo, l.getName(), true);
                                    continue;
                                }
                                row.writeText(thisInfo);
                            }
                        }
                        catch (Exception e) {
                            this.logger.log(Level.SEVERE, "Cannot write info column data: " + e.getMessage(), e);
                        }
                        editBanLink = new HtmlForm(this.getModuleName(), HtmlForm.Method.GET);
                        ((HtmlForm)editBanLink).addHiddenElement(GET_KEY, FUNCTION_NAME_EDIT_USER);
                        ((HtmlForm)editBanLink).addHiddenElement("id", b.getId() + "");
                        ((HtmlForm)editBanLink).addSubmit("Edit", HtmlForm.ButtonType.WARNING);
                        row.write((Builder)editBanLink);
                        if (b.isExpired()) {
                            row.writeText("Ban expired");
                        } else {
                            HtmlForm unbanLink = new HtmlForm(this.getModuleName() + "." + FUNCTION_NAME_UNBAN, HtmlForm.Method.POST);
                            unbanLink.addHiddenElement("id", b.getId() + "");
                            unbanLink.addSubmit("Unban", HtmlForm.ButtonType.SUCCESS);
                            row.write(unbanLink);
                        }
                        ht.write(row);
                    }
                    for (Ban b : expiredBans) {
                        row = ht.new HtmlTable.HtmlTableRow();
                        row.writeText(b.getId() + "");
                        row.writeText(b.getHash());
                        row.writeText(Ban.DEFAULT_TIME_FORMAT.format(b.getStart()));
                        if (b.isPermaBan()) {
                            row.writeText("---");
                            row.writeText("x");
                        } else {
                            row.writeText(Ban.DEFAULT_TIME_FORMAT.format(b.getEnd()));
                            row.writeText("");
                        }
                        try {
                            for (StringStringPair l : extraColumns) {
                                thisId = l.getId();
                                thisInfo = b.getInfo(thisId);
                                if (isLink.contains(thisId)) {
                                    if ("".equals(thisInfo)) {
                                        row.writeText(thisInfo);
                                        continue;
                                    }
                                    row.writeLink(thisInfo, l.getName(), true);
                                    continue;
                                }
                                row.writeText(thisInfo);
                            }
                        }
                        catch (Exception e) {
                            this.logger.log(Level.SEVERE, "Cannot write info column data: " + e.getMessage(), e);
                        }
                        editBanLink = new HtmlForm(this.getModuleName(), HtmlForm.Method.GET);
                        ((HtmlForm)editBanLink).addHiddenElement(GET_KEY, FUNCTION_NAME_EDIT_USER);
                        ((HtmlForm)editBanLink).addHiddenElement("id", b.getId() + "");
                        ((HtmlForm)editBanLink).addSubmit("Edit", HtmlForm.ButtonType.WARNING);
                        row.write((Builder)editBanLink);
                        row.writeText("Ban expired");
                        ht.write(row);
                    }
                    p.write(ht);
                    break;
                }
                default: {
                    p.writeText("unknown edit parameter");
                }
            }
        }
        return p.finish().getBytes();
    }

    @Override
    protected Map<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>> loadFunctions() {
        HashMap<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>> retMap = new HashMap<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>>();
        retMap.put(FUNCTION_NAME_ADD_BAN, this::addBan);
        retMap.put(FUNCTION_NAME_EDIT_BAN, this::editBan);
        retMap.put(FUNCTION_NAME_UNBAN, this::unban);
        retMap.put(FUNCTION_NAME_ADD_BANLIST, this::addBanlist);
        retMap.put(FUNCTION_NAME_EDIT_BANLIST, this::editBanlist);
        retMap.put(FUNCTION_NAME_REMOVE_BANLIST, this::removeBanlist);
        return retMap;
    }

    private FunctionResult addBan(AcpSession s, Map<String, String[]> parameters) {
        int bListId = Integer.parseInt(parameters.get("banlist_id")[0]);
        String hash = parameters.get("hash")[0];
        Banlist bList = Banlist.getBanlistById(this.dbCon, bListId);
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_ADD_BAN), bList.getAsset())) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, LOCATION);
        }
        JSONObject jO = new JSONObject();
        for (StringStringPair field : bList.getInfoColumns()) {
            if (!parameters.containsKey(GET_PREFIX_EXTRA_INFO + field.getId())) continue;
            jO.put(field.getId(), parameters.get(GET_PREFIX_EXTRA_INFO + field.getId())[0]);
        }
        String start = parameters.get("start")[0];
        String end = parameters.get("end")[0];
        boolean perm = parameters.containsKey(GET_PARAM_PERMABAN);
        Ban.addNewBan(this.dbCon, hash, bList.getId(), jO.toString(), start, end, perm);
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, LOCATION);
        r.getBuilder().addParameter(GET_KEY, FUNCTION_NAME_EDIT_BAN);
        r.getBuilder().addParameter("id", bList.getId() + "");
        return r;
    }

    private FunctionResult editBan(AcpSession s, Map<String, String[]> parameters) {
        int banId = Integer.parseInt(parameters.get("id")[0]);
        String hash = parameters.get("hash")[0];
        Ban b = Ban.getBanById(this.dbCon, banId);
        Banlist bList = Banlist.getBanlistById(this.dbCon, b.getBanlistId());
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_ADD_BAN), bList.getAsset())) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, LOCATION);
        }
        JSONObject jO = new JSONObject();
        for (StringStringPair field : bList.getInfoColumns()) {
            if (!parameters.containsKey(GET_PREFIX_EXTRA_INFO + field.getId())) continue;
            jO.put(field.getId(), parameters.get(GET_PREFIX_EXTRA_INFO + field.getId())[0]);
        }
        String start = parameters.get("start")[0];
        String end = parameters.get("end")[0];
        boolean perm = parameters.containsKey(GET_PARAM_PERMABAN);
        b.edit(this.dbCon, hash, jO.toString(), start, end, perm);
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, LOCATION);
        r.getBuilder().addParameter(GET_KEY, FUNCTION_NAME_EDIT_BAN);
        r.getBuilder().addParameter("id", bList.getId() + "");
        return r;
    }

    private FunctionResult unban(AcpSession s, Map<String, String[]> parameters) {
        int banId = Integer.parseInt(parameters.get("id")[0]);
        Ban b = Ban.getBanById(this.dbCon, banId);
        Banlist bList = Banlist.getBanlistById(this.dbCon, b.getBanlistId());
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_ADD_BAN), bList.getAsset())) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, LOCATION);
        }
        b.unban(this.dbCon);
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, LOCATION);
        r.getBuilder().addParameter(GET_KEY, FUNCTION_NAME_EDIT_BAN);
        r.getBuilder().addParameter("id", bList.getId() + "");
        return r;
    }

    private FunctionResult addBanlist(AcpSession s, Map<String, String[]> parameters) {
        String key = parameters.get("_key")[0];
        String name1 = parameters.get("name")[0];
        int gameId = Integer.parseInt(parameters.get("game_id")[0]);
        int communityId = Integer.parseInt(parameters.get("community_id")[0]);
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_ADD_BANLIST), Community.getCommunityById(this.dbCon, communityId).getAsset())) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, LOCATION);
        }
        Banlist.addNewBanlist(this.dbCon, key, name1, gameId, communityId);
        return new FunctionResult(FunctionResult.Status.OK, LOCATION);
    }

    private FunctionResult editBanlist(AcpSession s, Map<String, String[]> parameters) {
        int id = Integer.parseInt(parameters.get("id")[0]);
        String key = parameters.get("_key")[0];
        String name1 = parameters.get("name")[0];
        int gameId = Integer.parseInt(parameters.get("game_id")[0]);
        int communityId = Integer.parseInt(parameters.get("community_id")[0]);
        String infoColumnsRaw = parameters.get("info_columns")[0];
        JSONArray infoColumns = new JSONArray(infoColumnsRaw);
        Banlist b = Banlist.getBanlistById(this.dbCon, id);
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_EDIT_BANLIST), b.getAsset())) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, LOCATION);
        }
        b.editBanlist(this.dbCon, key, name1, gameId, communityId, infoColumns.toString());
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, LOCATION);
        r.getBuilder().addParameter(GET_KEY, FUNCTION_NAME_EDIT_BANLIST);
        r.getBuilder().addParameter("id", b.getId() + "");
        return r;
    }

    private FunctionResult removeBanlist(AcpSession s, Map<String, String[]> parameters) {
        int id = Integer.parseInt(parameters.get("id")[0]);
        Banlist b = Banlist.getBanlistById(this.dbCon, id);
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_REMOVE_BANLIST), b.getAsset())) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, LOCATION);
        }
        b.removeBanlist(this.dbCon);
        return new FunctionResult(FunctionResult.Status.OK, LOCATION);
    }
}

