/*
 * Decompiled with CFR 0.152.
 */
package co.clai.module;

import co.clai.AcpSession;
import co.clai.access.AccessibleFunctionHelper;
import co.clai.db.DatabaseConnector;
import co.clai.db.model.Ban;
import co.clai.db.model.Server;
import co.clai.db.model.Storage;
import co.clai.html.HtmlForm;
import co.clai.html.HtmlPage;
import co.clai.html.HtmlTable;
import co.clai.module.AbstractModule;
import co.clai.module.FunctionResult;
import co.clai.storage.AbstractStorage;
import co.clai.storage.StorageSearchEntry;
import co.clai.storage.StorageType;
import co.clai.util.IntStringPair;
import co.clai.util.ValueValuePair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.logging.Level;
import org.apache.http.client.utils.URIBuilder;

public class Search
extends AbstractModule {
    public static final String LOCATION = "search";
    public static final String TITLE = "Search logs and User";
    public static final String FUNCTION_NAME_SEARCH_USER = "searchForUser";
    public static final String FUNCTION_NAME_SEARCH_LOGS = "searchLogs";
    public static final String FUNCTION_NAME_VIEW_FILE = "viewFile";
    public static final String GET_PARAM = "do";
    private static final String GET_PARAM_VALUE_SEARCH_LOGS = "searchLogs";
    private static final String GET_PARAM_VALUE_SEARCH_USER = "searchUser";
    private static final String GET_PARAM_VALUE_LIST = "list";
    public static final String GET_PARAM_VALUE_VIEW = "view";
    public static final String GET_PARAM_VALUE_DOWNLOAD = "download";
    public static final String GET_PARAM_SEARCH_FOR = "search_for";
    private static final String GET_PARAM_SERVER_IDS = "server_ids";
    public static final String GET_PARAM_SERVER_START = "search_end";
    public static final String GET_PARAM_SERVER_END = "search_start";
    public static final String GET_PARAM_ALL_TIME = "all_time";
    private static final long THREE_MONTHS_IN_MILLIS = -295534592L;

    public Search(DatabaseConnector dbCon) {
        super(LOCATION, dbCon);
    }

    @Override
    protected byte[] invokePlain(AcpSession s, Map<String, String[]> parameters) {
        HtmlPage b;
        if (parameters.get(GET_PARAM) == null || parameters.get(GET_PARAM).length == 0) {
            HtmlPage p = new HtmlPage(this.dbCon, TITLE, null, null, null, s);
            p.writeH1("Search logs & access Files");
            HtmlForm searchLogs = new HtmlForm(LOCATION, HtmlForm.Method.GET);
            searchLogs.addHiddenElement(GET_PARAM, "searchLogs");
            searchLogs.addSubmit("Search chatlogs from server", HtmlForm.ButtonType.SUCCESS);
            p.write(searchLogs);
            HtmlForm searchUser = new HtmlForm(LOCATION, HtmlForm.Method.GET);
            searchUser.addHiddenElement(GET_PARAM, GET_PARAM_VALUE_SEARCH_USER);
            searchUser.addSubmit("Search for user", HtmlForm.ButtonType.SUCCESS);
            p.write(searchUser);
            HtmlForm accessFilesF = new HtmlForm(LOCATION, HtmlForm.Method.GET);
            accessFilesF.addHiddenElement(GET_PARAM, GET_PARAM_VALUE_LIST);
            accessFilesF.addSubmit("Access files from Storage", HtmlForm.ButtonType.SUCCESS);
            p.write(accessFilesF);
            return p.finish().getBytes();
        }
        switch (parameters.get(GET_PARAM)[0]) {
            case "searchLogs": {
                HtmlPage p;
                b = p = new HtmlPage(this.dbCon, TITLE, null, null, null, s);
                p.writeH2("Search logs:");
                ArrayList<ValueValuePair> serverSelection = new ArrayList<ValueValuePair>();
                HashSet<String> selectedServer = new HashSet<String>();
                List<Server> servers = Server.getAllServer(this.dbCon);
                for (Server ser : servers) {
                    if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(LOCATION, "searchLogs"), ser.getAsset())) continue;
                    serverSelection.add(new IntStringPair(ser.getId(), ser.getName()));
                }
                if (parameters.containsKey(GET_PARAM_SERVER_IDS)) {
                    for (String serverId : parameters.get(GET_PARAM_SERVER_IDS)) {
                        selectedServer.add(serverId);
                    }
                } else {
                    for (ValueValuePair servPair : serverSelection) {
                        selectedServer.add(servPair.getId());
                    }
                }
                HtmlForm searchForm = new HtmlForm(LOCATION, HtmlForm.Method.GET);
                searchForm.addHiddenElement(GET_PARAM, "searchLogs");
                if (parameters.containsKey(GET_PARAM_SEARCH_FOR)) {
                    searchForm.addTextElement("Search for", GET_PARAM_SEARCH_FOR, parameters.get(GET_PARAM_SEARCH_FOR)[0]);
                } else {
                    searchForm.addTextElement("Search for", GET_PARAM_SEARCH_FOR, "");
                }
                searchForm.addCheckboxGroup("Server", GET_PARAM_SERVER_IDS, serverSelection, selectedServer);
                searchForm.addTextElement("Start", GET_PARAM_SERVER_START, Ban.DEFAULT_TIME_FORMAT.format(new Date(System.currentTimeMillis() - -295534592L)));
                searchForm.addTextElement("End", GET_PARAM_SERVER_END, Ban.DEFAULT_TIME_FORMAT.format(new Date(System.currentTimeMillis())));
                searchForm.addCheckbox("All Time", GET_PARAM_ALL_TIME, "true", parameters.containsKey(GET_PARAM_ALL_TIME));
                searchForm.addSubmit("Search", HtmlForm.ButtonType.SUCCESS);
                p.write(searchForm);
                if (!parameters.containsKey(GET_PARAM_SEARCH_FOR) || "".equals(parameters.get(GET_PARAM_SEARCH_FOR)[0])) break;
                p.writeH2("Results:");
                HtmlTable resultTable = new HtmlTable();
                resultTable.startBody();
                String searchQuery = parameters.get(GET_PARAM_SEARCH_FOR)[0];
                boolean allTime = parameters.containsKey(GET_PARAM_ALL_TIME);
                Date start = null;
                Date end = null;
                if (!allTime) {
                    try {
                        start = Ban.DEFAULT_TIME_FORMAT.parse(parameters.get(GET_PARAM_SERVER_START)[0]);
                        end = Ban.DEFAULT_TIME_FORMAT.parse(parameters.get(GET_PARAM_SERVER_START)[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                for (String serverIdString : parameters.get(GET_PARAM_SERVER_IDS)) {
                    Server serv = Server.getServerById(this.dbCon, Integer.parseInt(serverIdString));
                    if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_SEARCH_USER), serv.getAsset())) {
                        p.writeText("no access!");
                        continue;
                    }
                    List<Storage> storages = Storage.getAllStorageByServerId(this.dbCon, serv.getId());
                    for (Storage stor : storages) {
                        if (stor.getType() != StorageType.LOG) continue;
                        resultTable.addRow(Arrays.asList(serv.getName(), stor.getName()));
                        try {
                            AbstractStorage thisRemoteStor = AbstractStorage.getRemoteFromLocation(stor);
                            List<StorageSearchEntry> results = allTime ? thisRemoteStor.searchForEntries(this.dbCon, searchQuery) : thisRemoteStor.searchForEntries(this.dbCon, searchQuery, start, end);
                            boolean canView = s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_VIEW_FILE), stor.getAsset(this.dbCon));
                            for (StorageSearchEntry result : results) {
                                HtmlTable.HtmlTableRow resultRow = resultTable.new HtmlTable.HtmlTableRow();
                                if (canView) {
                                    URIBuilder builder = new URIBuilder(LOCATION);
                                    builder.addParameter(GET_PARAM, GET_PARAM_VALUE_VIEW);
                                    builder.addParameter("storage_id", stor.getId() + "");
                                    builder.addParameter("identifier", result.getIdentifier());
                                    resultRow.writeLink(builder.toString(), result.getName(), true);
                                } else {
                                    resultRow.writeText(result.getName());
                                }
                                resultRow.writeText(result.getData());
                                resultTable.write(resultRow);
                            }
                        }
                        catch (Exception e) {
                            this.logger.log(Level.WARNING, "Error while searching through storage " + stor.getName() + ": " + e.getMessage());
                            e.printStackTrace();
                        }
                    }
                }
                p.write(resultTable);
                break;
            }
            case "searchUser": {
                HtmlPage p;
                b = p = new HtmlPage(this.dbCon, TITLE, null, null, null, s);
                break;
            }
            case "list": {
                HtmlPage p;
                b = p = new HtmlPage(this.dbCon, TITLE, null, null, null, s);
                HtmlTable ht = new HtmlTable();
                ht.addHeader(Arrays.asList("Id", "Key", "Name", "Server", "Type", "Local Indexed", "List"));
                ht.startBody();
                List<Storage> allStor = Storage.getAllStorage(this.dbCon);
                for (Storage stor : allStor) {
                    if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_VIEW_FILE), stor.getAsset(this.dbCon))) continue;
                    String serName = stor.getId() + "";
                    try {
                        serName = Server.getServerById(this.dbCon, stor.getServerId()).getName();
                    }
                    catch (Exception e) {
                        this.logger.log(Level.WARNING, "Error while getting server name from server #" + stor.getServerId() + ": " + e.getMessage());
                    }
                    HtmlTable.HtmlTableRow row = ht.new HtmlTable.HtmlTableRow();
                    row.writeText(stor.getId() + "");
                    row.writeText(stor.getKey());
                    row.writeText(stor.getName());
                    row.writeText(serName);
                    row.writeText(stor.getType().name().toLowerCase());
                    row.writeText(stor.isHasLocalIndex() + "");
                    HtmlForm listF = new HtmlForm(LOCATION, HtmlForm.Method.GET);
                    listF.addHiddenElement(GET_PARAM, GET_PARAM_VALUE_LIST);
                    listF.addHiddenElement("id", stor.getId() + "");
                    listF.addSubmit("List Files", HtmlForm.ButtonType.SUCCESS);
                    row.write(listF);
                    ht.write(row);
                }
                p.write(ht);
                if (!parameters.containsKey("id")) break;
                Storage stor = Storage.getStorageById(this.dbCon, Integer.parseInt(parameters.get("id")[0]));
                if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_VIEW_FILE), stor.getAsset(this.dbCon))) {
                    p.writeText("no access");
                    return p.finish().getBytes();
                }
                AbstractStorage abStor = AbstractStorage.getRemoteFromLocation(stor);
                HtmlTable fileList = new HtmlTable();
                fileList.addHeader(Arrays.asList("ID", "Name", "View"));
                fileList.startBody();
                for (ValueValuePair f : abStor.getFileList(this.dbCon)) {
                    HtmlTable.HtmlTableRow row = fileList.new HtmlTable.HtmlTableRow();
                    row.writeText(f.getId());
                    row.writeText(f.getName());
                    if (!abStor.forceDownload()) {
                        try {
                            row.writeLink(abStor.getViewLink(this.dbCon.getListener().getSiteUrl(), stor.getId(), f.getId()), GET_PARAM_VALUE_VIEW, true);
                        }
                        catch (Exception e) {
                            this.logger.log(Level.WARNING, "Error while building view link: " + e.getMessage());
                        }
                    } else {
                        row.writeText("");
                    }
                    try {
                        URIBuilder bu = new URIBuilder(LOCATION);
                        bu.addParameter(GET_PARAM, GET_PARAM_VALUE_DOWNLOAD);
                        bu.addParameter("storage_id", stor.getId() + "");
                        bu.addParameter("identifier", f.getId());
                        row.writeLink(bu.toString(), GET_PARAM_VALUE_DOWNLOAD, true);
                    }
                    catch (Exception e) {
                        this.logger.log(Level.WARNING, "Error while building download link: " + e.getMessage());
                    }
                    fileList.write(row);
                }
                p.write(fileList);
                break;
            }
            case "view": {
                HtmlPage p;
                b = p = new HtmlPage(this.dbCon, TITLE, null, null, null, s);
                int storageId = Integer.parseInt(parameters.get("storage_id")[0]);
                String identifier = parameters.get("identifier")[0];
                Storage stor = Storage.getStorageById(this.dbCon, storageId);
                if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_VIEW_FILE), stor.getAsset(this.dbCon))) {
                    return "no access".getBytes();
                }
                p.writeH2("Content: ");
                AbstractStorage.getRemoteFromLocation(stor).renderContent(p, identifier);
                break;
            }
            case "download": {
                int storageId = Integer.parseInt(parameters.get("storage_id")[0]);
                String identifier = parameters.get("identifier")[0];
                Storage stor = Storage.getStorageById(this.dbCon, storageId);
                if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_VIEW_FILE), stor.getAsset(this.dbCon))) {
                    return "no access".getBytes();
                }
                s.getResponse().setContentType("application/octet-stream");
                s.getResponse().addHeader("Content-Disposition", "inline; filename=\"" + identifier + "\"");
                return AbstractStorage.getRemoteFromLocation(stor).getData(identifier);
            }
            default: {
                HtmlPage p;
                b = p = new HtmlPage(this.dbCon, TITLE, null, null, null, s);
                p.writeText("unknown do Param");
            }
        }
        return b.finish().getBytes();
    }

    @Override
    protected Map<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>> loadFunctions() {
        HashMap<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>> retMap = new HashMap<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>>();
        retMap.put(FUNCTION_NAME_SEARCH_USER, null);
        retMap.put("searchLogs", null);
        retMap.put(FUNCTION_NAME_VIEW_FILE, null);
        return retMap;
    }
}

