/*
 * Decompiled with CFR 0.152.
 */
package co.clai.util.log;

import co.clai.util.log.GeneralOutputFormatter;
import co.clai.util.log.ModuleOutputFormatter;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.util.log.AbstractLogger;

public class Jetty2LoggerBridge
extends AbstractLogger {
    private static final String LOGGER_NAME_JETTY_LOG = "jetty-log";
    private final Logger logger = Logger.getLogger(this.name);
    private final String name;
    private boolean debugEnabled = true;

    public Jetty2LoggerBridge(String nameToBeIgnored) {
        this.name = LOGGER_NAME_JETTY_LOG;
        this.logger.setLevel(Level.WARNING);
        this.logger.setUseParentHandlers(false);
        ConsoleHandler hCon = new ConsoleHandler();
        hCon.setFormatter(new GeneralOutputFormatter());
        this.logger.addHandler(hCon);
        try {
            FileHandler fileHandler = new FileHandler("log/jetty.log", true);
            fileHandler.setFormatter(new ModuleOutputFormatter());
            this.logger.addHandler(fileHandler);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected org.eclipse.jetty.util.log.Logger newLogger(String fullname) {
        return new Jetty2LoggerBridge(fullname);
    }

    public String getName() {
        return this.name;
    }

    public void warn(String msg, Object ... args) {
        this.logger.log(Level.WARNING, msg, args);
    }

    public void warn(Throwable thrown) {
        this.warn(thrown.getMessage(), thrown);
    }

    public void warn(String msg, Throwable thrown) {
        this.logger.log(Level.WARNING, msg + " " + thrown.getMessage());
    }

    public void info(String msg, Object ... args) {
        this.logger.log(Level.INFO, msg, args);
    }

    public void info(Throwable thrown) {
        this.info(thrown.getMessage(), thrown);
    }

    public void info(String msg, Throwable thrown) {
        this.logger.log(Level.INFO, msg + " " + thrown.getMessage());
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled && this.logger.isLoggable(Level.FINE);
    }

    public void setDebugEnabled(boolean enabled) {
        this.debugEnabled = enabled;
    }

    public void debug(String msg, Object ... args) {
        if (this.debugEnabled) {
            this.logger.log(Level.FINE, msg, args);
        }
    }

    public void debug(Throwable thrown) {
        this.debug(thrown.getMessage(), thrown.getMessage());
    }

    public void debug(String msg, Throwable thrown) {
        if (this.debugEnabled) {
            this.logger.log(Level.FINE, msg + " " + thrown.getMessage());
        }
    }

    public void ignore(Throwable ignored) {
    }
}

