/*
 * Decompiled with CFR 0.152.
 */
package co.clai.db.model;

import co.clai.access.AssetServer;
import co.clai.access.CommunityAsset;
import co.clai.db.DatabaseConnector;
import co.clai.db.DbValue;
import co.clai.db.DbValueType;
import co.clai.db.model.AbstractDbTable;
import co.clai.db.model.Server;
import co.clai.db.model.Storage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class StorageIndex
extends AbstractDbTable {
    public static final String DB_TABLE_NAME = "storage_index";
    public static final String DB_TABLE_COLUMN_NAME_ID = "id";
    public static final String DB_TABLE_COLUMN_NAME_IDENTIFIER = "identifier";
    public static final String DB_TABLE_COLUMN_NAME_NAME = "name";
    public static final String DB_TABLE_COLUMN_NAME_STORAGE_ID = "storage_id";
    public static final String DB_TABLE_COLUMN_NAME_DATETIME = "datetime";
    public static final SimpleDateFormat DEFAULT_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd-kk-mm-ss");
    private static final Map<String, DbValueType> columnMap = new HashMap<String, DbValueType>();
    public static final StorageIndex dummyStorageIndex = new StorageIndex();
    private final int id;
    private final String identifier;
    private final String name;
    private final int storageId;
    private final Date datetime;

    public StorageIndex() {
        this(-1, null, null, -1, null);
    }

    private StorageIndex(int id, String identifier, String name, int storageId, String datetime) {
        super(DB_TABLE_NAME, columnMap);
        columnMap.put(DB_TABLE_COLUMN_NAME_ID, DbValueType.INTEGER);
        columnMap.put(DB_TABLE_COLUMN_NAME_IDENTIFIER, DbValueType.STRING);
        columnMap.put(DB_TABLE_COLUMN_NAME_NAME, DbValueType.STRING);
        columnMap.put(DB_TABLE_COLUMN_NAME_STORAGE_ID, DbValueType.INTEGER);
        columnMap.put(DB_TABLE_COLUMN_NAME_DATETIME, DbValueType.STRING);
        this.id = id;
        this.identifier = identifier;
        this.name = name;
        this.storageId = storageId;
        Date tmpDateTime = null;
        try {
            tmpDateTime = DEFAULT_TIME_FORMAT.parse(datetime);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "error while initializing datetime for index " + id + ": " + e.getMessage());
        }
        this.datetime = tmpDateTime;
    }

    public int getId() {
        return this.id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public int getStorageId() {
        return this.storageId;
    }

    public Date getDatetime() {
        return this.datetime;
    }

    public static StorageIndex getStorageById(DatabaseConnector dbCon, int storageId) {
        List<Map<String, DbValue>> results = dbCon.select(DB_TABLE_NAME, DB_TABLE_COLUMN_NAME_ID, new DbValue(storageId), dummyStorageIndex.getColumns());
        if (results.isEmpty()) {
            return null;
        }
        return StorageIndex.getStorageIndexFromResult(results.get(0));
    }

    private static StorageIndex getStorageIndexFromResult(Map<String, DbValue> parameters) {
        return new StorageIndex(parameters.get(DB_TABLE_COLUMN_NAME_ID).getInt(), parameters.get(DB_TABLE_COLUMN_NAME_IDENTIFIER).getString(), parameters.get(DB_TABLE_COLUMN_NAME_NAME).getString(), parameters.get(DB_TABLE_COLUMN_NAME_STORAGE_ID).getInt(), parameters.get(DB_TABLE_COLUMN_NAME_DATETIME).getString());
    }

    public static List<StorageIndex> getAllStorageIndex(DatabaseConnector dbCon) {
        ArrayList<StorageIndex> retList = new ArrayList<StorageIndex>();
        List<Map<String, DbValue>> results = dbCon.select(DB_TABLE_NAME, dummyStorageIndex.getColumns());
        for (Map<String, DbValue> r : results) {
            retList.add(StorageIndex.getStorageIndexFromResult(r));
        }
        return retList;
    }

    public static List<StorageIndex> getAllStorageIndexByStorageId(DatabaseConnector dbCon, int storageId) {
        ArrayList<StorageIndex> retList = new ArrayList<StorageIndex>();
        List<Map<String, DbValue>> results = dbCon.select(DB_TABLE_NAME, DB_TABLE_COLUMN_NAME_STORAGE_ID, new DbValue(storageId), dummyStorageIndex.getColumns());
        for (Map<String, DbValue> r : results) {
            retList.add(StorageIndex.getStorageIndexFromResult(r));
        }
        return retList;
    }

    public static void addNewStorage(DatabaseConnector dbCon, String name, String identifier, int storageId, long timestamp) {
        dbCon.insert(DB_TABLE_NAME, Arrays.asList(DB_TABLE_COLUMN_NAME_NAME, DB_TABLE_COLUMN_NAME_IDENTIFIER, DB_TABLE_COLUMN_NAME_STORAGE_ID, DB_TABLE_COLUMN_NAME_DATETIME), Arrays.asList(new DbValue(name), new DbValue(identifier), new DbValue(storageId), new DbValue(DEFAULT_TIME_FORMAT.format(new Date(timestamp)))));
    }

    public void delete(DatabaseConnector dbCon) {
        dbCon.deleteFrom(DB_TABLE_NAME, DB_TABLE_COLUMN_NAME_ID, new DbValue(this.id));
    }

    public CommunityAsset getAsset(DatabaseConnector dbCon) {
        Storage stor = Storage.getStorageById(dbCon, this.storageId);
        Server serv = stor.getServer(dbCon);
        return new AssetServer(this.id, serv.getCommunityId(), serv.getGameId());
    }
}

