/*
 * Decompiled with CFR 0.152.
 */
package co.clai.module;

import co.clai.AcpSession;
import co.clai.access.AccessibleFunctionHelper;
import co.clai.access.CommunityAsset;
import co.clai.access.GeneralAsset;
import co.clai.db.DatabaseConnector;
import co.clai.db.model.Community;
import co.clai.db.model.Location;
import co.clai.html.HtmlForm;
import co.clai.html.HtmlPage;
import co.clai.html.HtmlTable;
import co.clai.module.AbstractModule;
import co.clai.module.FunctionResult;
import co.clai.remote.AbstractRemoteConnection;
import co.clai.util.IntStringPair;
import co.clai.util.StringStringPair;
import co.clai.util.ValueValuePair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public class EditLocation
extends AbstractModule {
    public static final String FUNCTION_NAME_ADD_LOCATION = "addLocation";
    public static final String FUNCTION_NAME_EDIT_LOCATION = "editLocation";
    public static final String FUNCTION_NAME_DELETE_LOCATION = "deleteLocation";
    public static final String LOCATION = "editLocation";
    private static final String GET_PARAM = "edit";

    public EditLocation(DatabaseConnector dbCon) {
        super("editLocation", dbCon);
    }

    @Override
    protected byte[] invokePlain(AcpSession s, Map<String, String[]> parameters) {
        HtmlPage p = new HtmlPage(this.dbCon, "Edit Location", null, null, null, s);
        if (parameters.get(GET_PARAM) == null || parameters.get(GET_PARAM).length == 0) {
            p.writeH1("Edit Location");
            p.writeText("A location is a Forum running on a different server. Currently IPS, Xenforo and general oauth2 is supported");
            HtmlTable ht = new HtmlTable();
            ht.addHeader(Arrays.asList("ID", "name", "Community", "Edit", "Delete"));
            ht.startBody();
            List<Location> allLocations = Location.getAllLocations(this.dbCon);
            for (Location location : allLocations) {
                if (!s.getThisUser().hasAccess(this.getAccessibleHelper(), new GeneralAsset(location.getId(), location.getCommunityId()))) continue;
                HtmlTable.HtmlTableRow r = new HtmlTable.HtmlTableRow(ht);
                r.writeText(location.getId() + "");
                r.writeText(location.getName());
                r.writeText(Community.getCommunityById(this.dbCon, location.getCommunityId()).getName());
                HtmlForm editForm = new HtmlForm("editLocation", HtmlForm.Method.GET);
                editForm.addHiddenElement(GET_PARAM, "true");
                editForm.addHiddenElement(Location.DB_TABLE_COLUMN_NAME_ID, location.getId() + "");
                editForm.addSubmit("Edit", HtmlForm.ButtonType.PRIMARY);
                r.write(editForm);
                if (s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_DELETE_LOCATION), new GeneralAsset(location.getId(), location.getCommunityId()))) {
                    HtmlForm deleteForm = new HtmlForm("editLocation.deleteLocation", HtmlForm.Method.POST);
                    deleteForm.addHiddenElement(Location.DB_TABLE_COLUMN_NAME_ID, location.getId() + "");
                    deleteForm.addSubmit("Delete", HtmlForm.ButtonType.DANGER);
                    r.write(deleteForm);
                }
                ht.write(r);
            }
            p.write(ht);
            if (s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_ADD_LOCATION))) {
                ArrayList<ValueValuePair> selectionCommunityValues = new ArrayList<ValueValuePair>();
                if (s.getThisUser().getIsRoot()) {
                    selectionCommunityValues.add(new IntStringPair(0, "Community Wide"));
                }
                for (Community c : Community.getAllCommunity(this.dbCon)) {
                    if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_ADD_LOCATION), new CommunityAsset(c.getId()))) continue;
                    selectionCommunityValues.add(new IntStringPair(c.getId(), c.getName()));
                }
                HtmlForm htmlForm = new HtmlForm("editLocation.addLocation", HtmlForm.Method.POST);
                htmlForm.addTextElement("Name", Location.DB_TABLE_COLUMN_NAME_NAME, "");
                htmlForm.addSelectionDropdown("Community ID", Location.DB_TABLE_COLUMN_NAME_COMMUNITY_ID, selectionCommunityValues);
                ArrayList<ValueValuePair> typeSelector = new ArrayList<ValueValuePair>();
                for (String t : AbstractRemoteConnection.getAllTypes()) {
                    typeSelector.add(new StringStringPair(t, t));
                }
                htmlForm.addSelectionDropdown("Type", "type", typeSelector);
                htmlForm.addSubmit("Add new Location", HtmlForm.ButtonType.SUCCESS);
                p.write(htmlForm);
            }
        } else {
            Location l = Location.getLocationById(this.dbCon, Integer.parseInt(parameters.get(Location.DB_TABLE_COLUMN_NAME_ID)[0]));
            if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), "editLocation"), new GeneralAsset(l.getId(), l.getCommunityId()))) {
                p.writeText("no access");
                return p.finish().getBytes();
            }
            p.writeH1("Edit Location " + l.getName());
            HtmlForm editF = new HtmlForm("editLocation.editLocation", HtmlForm.Method.POST);
            editF.addHiddenElement(Location.DB_TABLE_COLUMN_NAME_ID, l.getId() + "");
            editF.addTextArea(Location.DB_TABLE_COLUMN_NAME_CONFIG, l.getConfig().toString(4), 20, 120);
            editF.addSubmit("Change Settings", HtmlForm.ButtonType.WARNING);
            p.write(editF);
        }
        return p.finish().getBytes();
    }

    @Override
    protected Map<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>> loadFunctions() {
        HashMap<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>> retMap = new HashMap<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>>();
        retMap.put(FUNCTION_NAME_ADD_LOCATION, this::addLocation);
        retMap.put("editLocation", this::editLocation);
        retMap.put(FUNCTION_NAME_DELETE_LOCATION, this::deleteLocation);
        return retMap;
    }

    private FunctionResult addLocation(AcpSession s, Map<String, String[]> parameter) {
        String thisName = parameter.get(Location.DB_TABLE_COLUMN_NAME_NAME)[0];
        int communityId = Integer.parseInt(parameter.get(Location.DB_TABLE_COLUMN_NAME_COMMUNITY_ID)[0]);
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_ADD_LOCATION), new CommunityAsset(communityId))) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, "editLocation");
        }
        String defData = AbstractRemoteConnection.getDefaultConfig(parameter.get("type")[0]);
        Location.addNewLocation(this.dbCon, thisName, communityId, defData);
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, "editLocation");
        r.getBuilder().addParameter(GET_PARAM, "true");
        r.getBuilder().addParameter(Location.DB_TABLE_COLUMN_NAME_ID, Location.getLocationByName(this.dbCon, thisName).getId() + "");
        return r;
    }

    private FunctionResult editLocation(AcpSession s, Map<String, String[]> parameter) {
        int locationId = Integer.parseInt(parameter.get(Location.DB_TABLE_COLUMN_NAME_ID)[0]);
        Location l = Location.getLocationById(this.dbCon, locationId);
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), "editLocation"), new GeneralAsset(l.getId(), l.getCommunityId()))) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, "editLocation");
        }
        l.changeConfig(this.dbCon, parameter.get(Location.DB_TABLE_COLUMN_NAME_CONFIG)[0]);
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, "editLocation");
        r.getBuilder().addParameter(GET_PARAM, "true");
        r.getBuilder().addParameter(Location.DB_TABLE_COLUMN_NAME_ID, l.getId() + "");
        return r;
    }

    private FunctionResult deleteLocation(AcpSession s, Map<String, String[]> parameter) {
        int locationId = Integer.parseInt(parameter.get(Location.DB_TABLE_COLUMN_NAME_ID)[0]);
        Location l = Location.getLocationById(this.dbCon, locationId);
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_DELETE_LOCATION), new GeneralAsset(l.getId(), l.getCommunityId()))) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, "editLocation");
        }
        l.delete(this.dbCon);
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, "editLocation");
        return r;
    }
}

