/*
 * Decompiled with CFR 0.152.
 */
package co.clai.remote;

import co.clai.module.FunctionResult;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.json.JSONObject;

public class OAuth2Helper {
    public static final String OAUTH_DATA_KEY_ACCESS_TOKEN = "access_token";
    public static final String OAUTH_DATA_KEY_CLIENT_ID = "client_id";
    public static final String OAUTH_DATA_KEY_REDIRECT_URI = "redirect_uri";
    public static final String OAUTH_DATA_KEY_CLIENT_SECRET = "client_secret";
    public static String OAUTH_DATA_KEY_CODE = "code";

    public static OAuth2Data getOAuth2Data(JSONObject data) {
        if (data == null) {
            return null;
        }
        if (!data.has("oauth2data")) {
            return null;
        }
        OAuth2Helper oAuth2Helper = new OAuth2Helper();
        oAuth2Helper.getClass();
        return oAuth2Helper.new OAuth2Data(data.getJSONObject("oauth2data"));
    }

    public static JSONObject generateOAuth2ConfigSkeleton() {
        JSONObject retObj = new JSONObject();
        retObj.put("clientId", "the Client comes here");
        retObj.put("clientSecret", "the Client secret here");
        retObj.put("authorizationUrl", "the Authorization Url here");
        retObj.put("accessTokenUrl", "the Access Tokel Url here");
        retObj.put("profileUrl", "the Profile Url here");
        return retObj;
    }

    public static FunctionResult generateRedirect(String acpSiteUrl, OAuth2Data oAuth2Data) {
        try {
            String remoteLoginUrl = oAuth2Data.authorizationUrl;
            URIBuilder b = new URIBuilder(remoteLoginUrl);
            b.addParameter(OAUTH_DATA_KEY_CLIENT_ID, oAuth2Data.clientId);
            b.addParameter(OAUTH_DATA_KEY_REDIRECT_URI, acpSiteUrl + "/" + "oauth2" + "." + "callback");
            b.addParameter("response_type", "code");
            return new FunctionResult(FunctionResult.Status.NONE, b);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> buildTokenRequest(String acpSiteUrl, String code, OAuth2Data oAuth2Data) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        retMap.put(OAUTH_DATA_KEY_CODE, code);
        retMap.put(OAUTH_DATA_KEY_CLIENT_ID, oAuth2Data.clientId);
        retMap.put(OAUTH_DATA_KEY_CLIENT_SECRET, oAuth2Data.clientSecret);
        retMap.put(OAUTH_DATA_KEY_REDIRECT_URI, acpSiteUrl + "/" + "oauth2" + "." + "callback");
        retMap.put("grant_type", "authorization_code");
        return retMap;
    }

    public static Map<String, String> buildUserRequest(String token) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        retMap.put(OAUTH_DATA_KEY_ACCESS_TOKEN, token);
        return retMap;
    }

    public class OAuth2Data {
        public static final String JSON_KEY_OAUTH2_DATA = "oauth2data";
        public static final String JSON_KEY_CLIENT_ID = "clientId";
        public static final String JSON_KEY_CLIENT_SECRET = "clientSecret";
        public static final String JSON_KEY_AUTHORIZATION_URL = "authorizationUrl";
        public static final String JSON_KEY_ACCESS_TOKEN_URL = "accessTokenUrl";
        public static final String JSON_KEY_PROFILE_URL = "profileUrl";
        public final String clientId;
        public final String clientSecret;
        public final String authorizationUrl;
        public final String accessTokenUrl;
        public final String profileUrl;

        public OAuth2Data(JSONObject data) {
            this.clientId = data.getString(JSON_KEY_CLIENT_ID);
            this.clientSecret = data.getString(JSON_KEY_CLIENT_SECRET);
            this.authorizationUrl = data.getString(JSON_KEY_AUTHORIZATION_URL);
            this.accessTokenUrl = data.getString(JSON_KEY_ACCESS_TOKEN_URL);
            this.profileUrl = data.getString(JSON_KEY_PROFILE_URL);
        }
    }
}

