/*
 * Decompiled with CFR 0.152.
 */
package co.clai.storage;

import co.clai.db.DatabaseConnector;
import co.clai.db.model.Storage;
import co.clai.html.HtmlPage;
import co.clai.remote.AbstractCachedQueryConnection;
import co.clai.storage.StorageSearchEntry;
import co.clai.util.ValueValuePair;
import java.lang.reflect.Constructor;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.http.client.utils.URIBuilder;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public abstract class AbstractStorage
extends AbstractCachedQueryConnection {
    public static final String REMOTE_LOCATION_CONFIG_KEY_TYPE = "type";
    public static final String UNIQUE_ID_KEY = "uniqueId";
    private static final Map<String, Class<? extends AbstractStorage>> allStorages = AbstractStorage.loadAbstractStorage();

    private static Map<String, Class<? extends AbstractStorage>> loadAbstractStorage() {
        HashMap<String, Class<? extends AbstractStorage>> reMap = new HashMap<String, Class<? extends AbstractStorage>>();
        Reflections reflections = new Reflections("co.clai.storage", new Scanner[0]);
        Set allClasses = reflections.getSubTypesOf(AbstractStorage.class);
        for (Class c : allClasses) {
            logger.log(Level.INFO, "loading abstract Storage class " + c.getName());
            String name = null;
            try {
                Constructor cons = c.getConstructor(Storage.class);
                AbstractStorage r = (AbstractStorage)cons.newInstance(new Object[]{null});
                name = r.getStorageTypeName();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            logger.log(Level.INFO, "with name " + name);
            reMap.put(name, c);
        }
        return reMap;
    }

    public static List<AbstractStorage> getAllAbstractStorage() {
        ArrayList<AbstractStorage> retList = new ArrayList<AbstractStorage>();
        Reflections reflections = new Reflections("co.clai.storage", new Scanner[0]);
        Set allClasses = reflections.getSubTypesOf(AbstractStorage.class);
        for (Class c : allClasses) {
            try {
                Constructor cons = c.getConstructor(Storage.class);
                AbstractStorage m = (AbstractStorage)cons.newInstance(new Object[]{null});
                retList.add(m);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return retList;
    }

    public static AbstractStorage getRemoteFromLocation(Storage stor) {
        Class<? extends AbstractStorage> c = allStorages.get(stor.getConfig().getString(REMOTE_LOCATION_CONFIG_KEY_TYPE));
        try {
            Constructor<? extends AbstractStorage> cons = c.getConstructor(Storage.class);
            return cons.newInstance(stor);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "error while creating RemoteConnection", e);
            return null;
        }
    }

    protected static List<StorageSearchEntry> getSearchResult(String identifier, String name, String regExp, String content) {
        ArrayList<StorageSearchEntry> retList = new ArrayList<StorageSearchEntry>();
        for (String s : content.split("\n")) {
            if (!s.contains(regExp) && !s.matches(regExp)) continue;
            retList.add(new StorageSearchEntry(identifier, name, s));
        }
        return retList;
    }

    public static List<String> getAllTypes() {
        ArrayList<String> retList = new ArrayList<String>();
        retList.addAll(allStorages.keySet());
        return retList;
    }

    public abstract String getStorageTypeName();

    public abstract boolean needsApproval();

    public abstract boolean isCloud();

    public abstract byte[] getData(String var1);

    public List<ValueValuePair> getFileList(DatabaseConnector dbCon) {
        return this.getFileListByDate(dbCon, new Date(0L), new Date(System.currentTimeMillis()));
    }

    public abstract List<ValueValuePair> getFileListByDate(DatabaseConnector var1, Date var2, Date var3);

    public abstract List<StorageSearchEntry> searchForEntries(DatabaseConnector var1, String var2);

    public abstract List<StorageSearchEntry> searchForEntries(DatabaseConnector var1, String var2, Date var3, Date var4);

    public abstract void pushIndex(DatabaseConnector var1, String var2, String var3, long var4, String var6);

    public void renderContent(HtmlPage p, String identifier) {
        p.writePre(new String(this.getData(identifier)));
    }

    public abstract boolean forceDownload();

    public abstract boolean isSearchable();

    public String getViewLink(String siteURL, int storageId, String identifier) throws URISyntaxException {
        URIBuilder bu = new URIBuilder("search");
        bu.addParameter("do", "view");
        bu.addParameter("storage_id", storageId + "");
        bu.addParameter("identifier", identifier);
        return bu.toString();
    }
}

