/*
 * Decompiled with CFR 0.152.
 */
package co.clai;

import co.clai.db.DatabaseConnector;
import co.clai.db.model.User;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AcpSession {
    private final HttpSession session;
    private final User thisUser;
    private final DatabaseConnector dbCon;
    private final String clientIp;
    private final String hostname;
    private final HttpServletResponse response;

    AcpSession(DatabaseConnector dbCon, HttpServletRequest request, HttpServletResponse response) {
        this.session = request.getSession();
        this.hostname = request.getServerName();
        this.response = response;
        this.dbCon = dbCon;
        String tmpClientIp = request.getRemoteAddr();
        if (tmpClientIp.equals("127.0.0.1")) {
            if (request.getHeader("X-Real-IP") != null) {
                tmpClientIp = request.getHeader("X-Real-IP");
            } else if (request.getHeader("X-Forwarded-For") != null) {
                tmpClientIp = request.getHeader("X-Forwarded-For");
            }
        }
        this.clientIp = tmpClientIp;
        if (this.session.getAttribute("userLocation") == null || this.session.getAttribute("userId") == null) {
            this.thisUser = null;
        } else {
            int location = (Integer)this.session.getAttribute("userLocation");
            int id = (Integer)this.session.getAttribute("userId");
            this.thisUser = User.getUserByLocationId(dbCon, location, id);
        }
    }

    public User getThisUser() {
        return this.thisUser;
    }

    public void setUser(User u) {
        if (u == null) {
            this.session.removeAttribute("userLocation");
            this.session.removeAttribute("userId");
            return;
        }
        this.session.setAttribute("userLocation", (Object)new Integer(u.getLocationId()));
        this.session.setAttribute("userId", (Object)new Integer(u.getId()));
    }

    public HttpSession getSession() {
        return this.session;
    }

    public void clear() {
        this.session.invalidate();
    }

    public DatabaseConnector getDbCon() {
        return this.dbCon;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getHostname() {
        return this.hostname;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }
}

