/*
 * Decompiled with CFR 0.152.
 */
package co.clai.game;

import co.clai.AcpSession;
import co.clai.access.AccessibleFunctionHelper;
import co.clai.db.DatabaseConnector;
import co.clai.db.model.Server;
import co.clai.db.model.ServerSetting;
import co.clai.db.model.Template;
import co.clai.game.AbstractGame;
import co.clai.game.squad.QuerySquad;
import co.clai.html.Builder;
import co.clai.html.GenericBuffer;
import co.clai.html.HtmlForm;
import co.clai.module.Query;
import co.clai.util.StringStringPair;
import co.clai.util.log.LoggingUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Squad
extends AbstractGame {
    private static final String QUERY_KEY_SERVER_CFG = "server_cfg";
    private static final String QUERY_KEY_BAN_CFG = "ban_cfg";
    private static final String QUERY_KEY_ADMINS_CFG = "admins_cfg";
    private static final String QUERY_KEY_RESERVEDSLOTS = "reserved_slots";
    private static final String CONFIG_KEY_IP = "ip";
    private static final String CONFIG_KEY_PORT = "port";
    private static final String CONFIG_KEY_QUERY = "query";
    private static final String CONFIG_KEY_TEMPLATE_SERVER_CFG = "template_server_cfg";
    public static final String CONFIG_KEY_ADMIN_GROUPS = "admin_groups";
    public static final String CONFIG_KEY_RESERVED_GROUPS = "reserved_groups";
    public static final String KEY = "squad";
    public static final String NAME = "Squad";
    private final Map<String, String> options = Squad.loadOptions();
    private final Logger logger = LoggingUtil.getLoggerFromModule(Query.class);

    private static Map<String, String> loadOptions() {
        HashMap<String, String> retMap = new HashMap<String, String>();
        retMap.put(CONFIG_KEY_IP, "IP Adress");
        retMap.put(CONFIG_KEY_PORT, "Game Port");
        retMap.put(CONFIG_KEY_QUERY, "Query Port");
        retMap.put(CONFIG_KEY_TEMPLATE_SERVER_CFG, "Template for Server.cfg");
        retMap.put(CONFIG_KEY_ADMIN_GROUPS, "Admin Usergroups");
        retMap.put(CONFIG_KEY_RESERVED_GROUPS, "Groups with reserved Slot");
        return retMap;
    }

    protected Squad() {
        super(KEY, NAME);
    }

    @Override
    public List<StringStringPair> getAvailableOptions() {
        ArrayList<StringStringPair> retOptions = new ArrayList<StringStringPair>();
        for (Map.Entry<String, String> e : this.options.entrySet()) {
            retOptions.add(new StringStringPair(e.getKey(), e.getValue()));
        }
        return retOptions;
    }

    @Override
    public Builder renderOption(AcpSession s, ServerSetting setting) {
        HtmlForm hf = new HtmlForm("editServer.editSetting", HtmlForm.Method.POST);
        GenericBuffer b = new GenericBuffer("");
        String setKey = setting.getSettingKey();
        boolean hasDeleteButton = false;
        switch (setKey) {
            case "admin_groups": 
            case "reserved_groups": {
                hf.writeText(this.options.get(setKey) + ":");
                hf.addTextArea("data", new String(setting.getData()), 5, 15);
                hasDeleteButton = true;
                break;
            }
            case "ip": 
            case "port": 
            case "query": {
                hf.addTextElement(this.options.get(setKey), "data", new String(setting.getData()));
                break;
            }
            case "template_server_cfg": {
                hf.addSelectionDropdown(this.options.get(setKey), "data", Template.getAccessibleTemplates(new AccessibleFunctionHelper("editServer", "editSetting"), s.getDbCon(), s.getThisUser()), new String(setting.getData()));
                break;
            }
            default: {
                hf.addTextElement("Unknown option " + setKey, "data", new String(setting.getData()));
            }
        }
        hf.addHiddenElement("id", setting.getId() + "");
        hf.addSubmit("Change Value", HtmlForm.ButtonType.WARNING);
        b.write(hf);
        if (hasDeleteButton) {
            HtmlForm deleteButtonF = new HtmlForm("editServer.removeSetting", HtmlForm.Method.POST, null);
            deleteButtonF.addHiddenElement("id", setting.getId() + "");
            deleteButtonF.addSubmit("Delete Setting", HtmlForm.ButtonType.DANGER);
            b.write(deleteButtonF);
        }
        return b;
    }

    @Override
    public List<StringStringPair> getAvailableQueries() {
        ArrayList<StringStringPair> retOptions = new ArrayList<StringStringPair>();
        retOptions.addAll(Arrays.asList(new StringStringPair(QUERY_KEY_ADMINS_CFG, "Admins.cfg file"), new StringStringPair(QUERY_KEY_BAN_CFG, "Bans.cfg file"), new StringStringPair(QUERY_KEY_SERVER_CFG, "Server.cfg file"), new StringStringPair(QUERY_KEY_RESERVEDSLOTS, "Reserved Slots Admin config")));
        return retOptions;
    }

    @Override
    public String executeQuery(DatabaseConnector dbCon, String command, Server server, Map<String, String[]> parameters, AcpSession session) {
        switch (command) {
            case "admins_cfg": {
                StringBuilder sb = new StringBuilder();
                QuerySquad.generateAdminConfig(dbCon, sb, server);
                return sb.toString();
            }
            case "reserved_slots": {
                StringBuilder sb = new StringBuilder();
                QuerySquad.generateReservedSlots(dbCon, sb, server);
                return sb.toString();
            }
        }
        this.logger.log(Level.WARNING, "Unknown query command '" + command + "'!");
        return "";
    }

    @Override
    public String getDefaultOption(String settingKey) {
        switch (settingKey) {
            case "reserved_groups": {
                return "[\n{\n    \"location\" : \"<location id>\",\n    \"field_id\" : \"<field id>\",\n    \"groups\" : \"<group 1>,<group 2>\"\n}\n]\n";
            }
            case "admin_groups": {
                return "{\n\"roles\": [\n\"Group=Admin:kick,changemap,immunity,chat,canseeadminchat\",\n],\n\"group_access\" : [\n{\n    \"location\" : \"<location id>\",\n    \"field_id\" : \"<field id>\",\n    \"groups\" : [\n        {\n            \"role\" : \"<role 1>\",\n            \"groups\" : \"<group 1>,<group 2>\"\n        }\n}\n]\n}";
            }
            case "port": {
                return "7787";
            }
            case "query": {
                return "27165";
            }
        }
        return "";
    }
}

