/*
 * Decompiled with CFR 0.152.
 */
package co.clai.game.prbf2;

import co.clai.db.DatabaseConnector;
import co.clai.db.model.Location;
import co.clai.db.model.Server;
import co.clai.db.model.ServerSetting;
import co.clai.module.Query;
import co.clai.remote.AbstractRemoteConnection;
import co.clai.util.StringUtil;
import co.clai.util.log.LoggingUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class QueryPrbf2 {
    private static final Logger logger = LoggingUtil.getLoggerFromModule(Query.class);

    public static void appendAdminHashes(DatabaseConnector dbCon, StringBuilder sb, Server server) {
        ServerSetting adminGroupSetting = ServerSetting.getServerSettingByServerIdAndKey(dbCon, server.getId(), "admin_groups");
        StringBuilder adminConfigSb = new StringBuilder();
        try {
            if (adminGroupSetting != null) {
                HashMap<String, String> userRoleMap = new HashMap<String, String>();
                String adminSettingData = new String(adminGroupSetting.getData());
                JSONArray locationArr = new JSONArray(adminSettingData);
                for (int i = 0; i < locationArr.length(); ++i) {
                    JSONObject locationConfig = locationArr.getJSONObject(i);
                    Location location = Location.getLocationById(dbCon, Integer.parseInt(locationConfig.getString("location")));
                    if (location.getCommunityId() != server.getCommunityId()) {
                        logger.log(Level.WARNING, "server config tried to pull admin data from wrong community, serverid=" + server.getId() + ", key=" + "admin_groups");
                        continue;
                    }
                    String fieldId = locationConfig.getString("field_id");
                    JSONArray userGroupConfig = locationConfig.getJSONArray("groups");
                    AbstractRemoteConnection con = AbstractRemoteConnection.getRemoteFromLocation(location);
                    for (int j = 0; j < userGroupConfig.length(); ++j) {
                        JSONObject groupConfig = userGroupConfig.getJSONObject(j);
                        String role = groupConfig.getString("role");
                        String[] groups = groupConfig.getString("groups").split(",");
                        ArrayList<Integer> groupIds = new ArrayList<Integer>();
                        for (String gr : groups) {
                            if ("".equals(gr)) continue;
                            groupIds.add(new Integer(gr));
                        }
                        for (Integer groupId : groupIds) {
                            List<Integer> userIdList = con.getUserIdsFromUserGroup(groupId);
                            for (Integer userId : userIdList) {
                                String adminHash = con.getUserFieldContentFromUserId(fieldId, userId);
                                if (adminHash == null || !StringUtil.containsOnlyNumbersAndLetters(adminHash)) continue;
                                userRoleMap.put(adminHash, role);
                            }
                        }
                    }
                }
                adminConfigSb.append("adm_adminHashes = {\n");
                for (Map.Entry e : userRoleMap.entrySet()) {
                    adminConfigSb.append("\"" + (String)e.getKey() + "\" : " + (String)e.getValue() + ",\n");
                }
                adminConfigSb.append("}\n");
                sb.append(adminConfigSb.toString());
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "error occured while trying to fetch remote Admin access from config, serverid=" + server.getId() + ", key=" + "admin_groups" + ": " + e.getMessage());
            e.printStackTrace();
        }
        ServerSetting ambExcludeListSetting = ServerSetting.getServerSettingByServerIdAndKey(dbCon, server.getId(), "smb_excludeList");
        try {
            if (ambExcludeListSetting != null) {
                sb.append("smb_excludeList = " + ambExcludeListSetting.getDataAsString());
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "error occured while trying to fetch remote Admin access from config, serverid=" + server.getId() + ", key=" + "admin_groups" + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void appendServerSettings(DatabaseConnector dbCon, StringBuilder sb, Server server) {
        try {
            ServerSetting localIpSetting = ServerSetting.getServerSettingByServerIdAndKey(dbCon, server.getId(), "local_ip");
            if (localIpSetting != null) {
                sb.append("sv.serverIP \"" + localIpSetting.getDataAsString() + "\"\n");
            } else {
                ServerSetting ipSetting = ServerSetting.getServerSettingByServerIdAndKey(dbCon, server.getId(), "ip");
                sb.append("sv.serverIP \"" + ipSetting.getDataAsString() + "\"\n");
            }
            sb.append("sv.internet 1\n");
            QueryPrbf2.appendSettingIfExists(dbCon, sb, server, "sv.serverPort ", "\n", "port");
            QueryPrbf2.appendSettingIfExists(dbCon, sb, server, "sv.gameSpyPort ", "\n", "query");
            QueryPrbf2.appendSettingIfExists(dbCon, sb, server, "sv.adminScript \"", "\"\n", "sv_adminScript");
            QueryPrbf2.appendSettingIfExists(dbCon, sb, server, "sv.serverName \"", "\"\n", "browser_name");
            QueryPrbf2.appendSettingIfExists(dbCon, sb, server, "sv.password \"", "\"\n", "sv_password");
            QueryPrbf2.appendSettingIfExists(dbCon, sb, server, "sv.welcomeMessage \"", "\"\n", "sv_welcomeMessage");
            QueryPrbf2.appendSettingIfExists(dbCon, sb, server, "sv.sponsorText \"", "\"\n", "sv_welcomeMessage");
            QueryPrbf2.appendSettingIfExists(dbCon, sb, server, "sv.sponsorLogoURL \"", "\"\n", "sv_LogoURL");
            QueryPrbf2.appendSettingIfExists(dbCon, sb, server, "sv.communityLogoURL \"", "\"\n", "sv_LogoURL");
            QueryPrbf2.appendSettingIfExists(dbCon, sb, server, "sv.maxPlayers ", "\n", "sv_maxPlayers");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "error occured while trying to fetch remote Admin access from config, serverid=" + server.getId() + ", key=" + "admin_groups" + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void appendSettingIfExists(DatabaseConnector dbCon, StringBuilder sb, Server server, String infront, String behind, String key) {
        ServerSetting setting = ServerSetting.getServerSettingByServerIdAndKey(dbCon, server.getId(), key);
        if (setting != null) {
            sb.append(infront + setting.getDataAsString() + behind);
        }
    }
}

