/*
 * Decompiled with CFR 0.152.
 */
package co.clai.module;

import co.clai.AcpSession;
import co.clai.access.AccessibleFunctionHelper;
import co.clai.access.GeneralAsset;
import co.clai.db.DatabaseConnector;
import co.clai.db.model.Server;
import co.clai.db.model.Storage;
import co.clai.html.HtmlForm;
import co.clai.html.HtmlPage;
import co.clai.html.HtmlTable;
import co.clai.module.AbstractModule;
import co.clai.module.FunctionResult;
import co.clai.storage.StorageType;
import co.clai.util.IntStringPair;
import co.clai.util.StringStringPair;
import co.clai.util.ValueValuePair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.logging.Level;
import org.json.JSONObject;

public class EditStorage
extends AbstractModule {
    public static final String FUNCTION_NAME_ADD_STORAGE = "addStorage";
    public static final String FUNCTION_NAME_EDIT_STORAGE = "editStorage";
    public static final String FUNCTION_NAME_EDIT_STORAGE_CONFIG = "editStorageConfig";
    public static final String FUNCTION_NAME_DELETE_STORAGE = "deleteStorage";
    public static final String LOCATION = "editStorage";
    private static final String GET_PARAM = "edit";

    public EditStorage(DatabaseConnector dbCon) {
        super("editStorage", dbCon);
    }

    @Override
    protected byte[] invokePlain(AcpSession s, Map<String, String[]> parameters) {
        HtmlPage p = new HtmlPage(this.dbCon, "Edit Storage", null, null, null, s);
        if (parameters.get(GET_PARAM) == null || parameters.get(GET_PARAM).length == 0) {
            p.writeH1("Edit Storage");
            HtmlTable ht = new HtmlTable();
            ht.addHeader(Arrays.asList("ID", "key", "Name", "Server", "type", "indexed", "Edit", "Delete"));
            ht.startBody();
            List<Storage> allStorages = Storage.getAllStorage(this.dbCon);
            for (Storage storage : allStorages) {
                HtmlForm storEditForm;
                if (!s.getThisUser().hasAccess(this.getAccessibleHelper(), storage.getAsset(this.dbCon))) continue;
                HtmlTable.HtmlTableRow r = new HtmlTable.HtmlTableRow(ht);
                r.writeText(storage.getId() + "");
                r.writeText(storage.getKey());
                r.writeText(storage.getName());
                Server server = null;
                try {
                    server = Server.getServerById(this.dbCon, storage.getServerId());
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, "storage with ID " + storage.getId() + " failed to get Server name: " + e.getMessage());
                }
                r.writeText(server == null ? storage.getServerId() + "" : server.getName());
                r.writeText(storage.getType().name().toLowerCase());
                r.writeText(storage.isHasLocalIndex() ? "x" : "");
                if (s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_EDIT_STORAGE_CONFIG), storage.getAsset(this.dbCon))) {
                    storEditForm = new HtmlForm("editStorage", HtmlForm.Method.GET);
                    storEditForm.addHiddenElement(GET_PARAM, FUNCTION_NAME_EDIT_STORAGE_CONFIG);
                    storEditForm.addHiddenElement("id", storage.getId() + "");
                    storEditForm.addSubmit("Edit", HtmlForm.ButtonType.WARNING);
                    r.write(storEditForm);
                } else {
                    r.writeText("");
                }
                if (s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_DELETE_STORAGE), storage.getAsset(this.dbCon))) {
                    storEditForm = new HtmlForm("editStorage.deleteStorage", HtmlForm.Method.POST);
                    storEditForm.addHiddenElement("id", storage.getId() + "");
                    storEditForm.addSubmit("Delete", HtmlForm.ButtonType.DANGER);
                    r.write(storEditForm);
                }
                ht.write(r);
            }
            p.write(ht);
            if (s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_ADD_STORAGE))) {
                p.writeH2("Add new Storage:");
                ArrayList<ValueValuePair> selectionServerValues = new ArrayList<ValueValuePair>();
                for (Server ser : Server.getAllServer(this.dbCon)) {
                    if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_ADD_STORAGE), ser.getAsset())) continue;
                    selectionServerValues.add(new IntStringPair(ser.getId(), ser.getName()));
                }
                HtmlForm htmlForm = new HtmlForm("editStorage.addStorage", HtmlForm.Method.POST);
                htmlForm.addTextElement("Key", "_key", "");
                htmlForm.addTextElement("Name", "name", "");
                htmlForm.addSelectionDropdown("Server", "server_id", selectionServerValues);
                ArrayList<ValueValuePair> typeSelector = new ArrayList<ValueValuePair>();
                for (StorageType t : StorageType.values()) {
                    typeSelector.add(new StringStringPair(t.name().toLowerCase(), t.name().toLowerCase()));
                }
                htmlForm.addSelectionDropdown("Type", "type", typeSelector);
                htmlForm.addSubmit("Add new Storage", HtmlForm.ButtonType.SUCCESS);
                p.write(htmlForm);
            }
        } else {
            Storage stor = Storage.getStorageById(this.dbCon, Integer.parseInt(parameters.get("id")[0]));
            if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_EDIT_STORAGE_CONFIG), new GeneralAsset(stor.getId(), stor.getServer(this.dbCon).getCommunityId()))) {
                p.writeText("no access");
                return p.finish().getBytes();
            }
            p.writeH1("Edit Storage " + stor.getName());
            p.writeH2("Edit general info:");
            HtmlForm editF = new HtmlForm("editStorage.editStorage", HtmlForm.Method.POST);
            ArrayList<ValueValuePair> selectionServerValues = new ArrayList<ValueValuePair>();
            for (Server ser : Server.getAllServer(this.dbCon)) {
                if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_ADD_STORAGE), ser.getAsset())) continue;
                selectionServerValues.add(new IntStringPair(ser.getId(), ser.getName()));
            }
            editF.addTextElement("Key", "_key", stor.getKey());
            editF.addTextElement("Name", "name", stor.getName());
            editF.addSelectionDropdown("Server", "server_id", selectionServerValues, stor.getServerId() + "");
            editF.addCheckbox("Has Local Index", "has_local_index", "true", stor.isHasLocalIndex());
            editF.addHiddenElement("id", stor.getId() + "");
            editF.addSubmit("Update Values", HtmlForm.ButtonType.PRIMARY);
            p.write(editF);
            p.writeH2("Edit config:");
            HtmlForm htmlForm = new HtmlForm("editStorage.editStorageConfig", HtmlForm.Method.POST);
            htmlForm.addTextArea("config", stor.getConfig().toString(4), 20, 120);
            htmlForm.addHiddenElement("id", stor.getId() + "");
            htmlForm.addSubmit("Update Config", HtmlForm.ButtonType.PRIMARY);
            p.write(htmlForm);
        }
        return p.finish().getBytes();
    }

    @Override
    protected Map<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>> loadFunctions() {
        HashMap<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>> retMap = new HashMap<String, BiFunction<AcpSession, Map<String, String[]>, FunctionResult>>();
        retMap.put(FUNCTION_NAME_ADD_STORAGE, this::addStorage);
        retMap.put("editStorage", this::editStorage);
        retMap.put(FUNCTION_NAME_EDIT_STORAGE_CONFIG, this::editStorageConfig);
        retMap.put(FUNCTION_NAME_DELETE_STORAGE, this::deleteStorage);
        return retMap;
    }

    private FunctionResult addStorage(AcpSession s, Map<String, String[]> parameter) {
        String key = parameter.get("_key")[0];
        String name1 = parameter.get("name")[0];
        int serverId = Integer.parseInt(parameter.get("server_id")[0]);
        String typeS = parameter.get("type")[0];
        StorageType type = StorageType.valueOf(typeS.toUpperCase());
        Server serv = Server.getServerById(this.dbCon, serverId);
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_ADD_STORAGE), serv.getAsset())) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, "editStorage");
        }
        Storage.addNewStorage(this.dbCon, key, name1, serverId, type, new JSONObject());
        FunctionResult fR = new FunctionResult(FunctionResult.Status.OK, "editStorage");
        fR.getBuilder().addParameter(GET_PARAM, FUNCTION_NAME_EDIT_STORAGE_CONFIG);
        fR.getBuilder().addParameter("id", Storage.getStorageByKey(this.dbCon, key).getId() + "");
        return fR;
    }

    private FunctionResult editStorage(AcpSession s, Map<String, String[]> parameter) {
        int StorageId = Integer.parseInt(parameter.get("id")[0]);
        Storage stor = Storage.getStorageById(this.dbCon, StorageId);
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_EDIT_STORAGE_CONFIG), new GeneralAsset(stor.getId(), stor.getServer(this.dbCon).getCommunityId()))) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, "editStorage");
        }
        stor.edit(this.dbCon, parameter.get("_key")[0], parameter.get("name")[0], Integer.parseInt(parameter.get("server_id")[0]), parameter.containsKey("has_local_index"));
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, "editStorage");
        r.getBuilder().addParameter(GET_PARAM, "true");
        r.getBuilder().addParameter("id", stor.getId() + "");
        return r;
    }

    private FunctionResult editStorageConfig(AcpSession s, Map<String, String[]> parameter) {
        int StorageId = Integer.parseInt(parameter.get("id")[0]);
        Storage stor = Storage.getStorageById(this.dbCon, StorageId);
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_EDIT_STORAGE_CONFIG), new GeneralAsset(stor.getId(), stor.getServer(this.dbCon).getCommunityId()))) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, "editStorage");
        }
        stor.changeConfig(this.dbCon, parameter.get("config")[0]);
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, "editStorage");
        r.getBuilder().addParameter(GET_PARAM, "true");
        r.getBuilder().addParameter("id", stor.getId() + "");
        return r;
    }

    private FunctionResult deleteStorage(AcpSession s, Map<String, String[]> parameter) {
        int StorageId = Integer.parseInt(parameter.get("id")[0]);
        Storage stor = Storage.getStorageById(this.dbCon, StorageId);
        if (!s.getThisUser().hasAccess(new AccessibleFunctionHelper(this.getModuleName(), FUNCTION_NAME_DELETE_STORAGE), new GeneralAsset(stor.getId(), stor.getServer(this.dbCon).getCommunityId()))) {
            return new FunctionResult(FunctionResult.Status.NO_ACCESS, "editStorage");
        }
        stor.delete(this.dbCon);
        FunctionResult r = new FunctionResult(FunctionResult.Status.OK, "editStorage");
        return r;
    }
}

