/*
 * Decompiled with CFR 0.152.
 */
package co.clai.remote;

import co.clai.db.DatabaseConnector;
import co.clai.db.model.Location;
import co.clai.db.model.User;
import co.clai.html.Builder;
import co.clai.remote.AbstractRemoteConnection;
import co.clai.remote.DummyConnection;
import co.clai.remote.OAuth2Helper;
import co.clai.remote.RemoteUserData;
import co.clai.util.HttpRequestUtil;
import co.clai.util.RandomUtil;
import co.clai.util.StringStringPair;
import co.clai.util.StringUtil;
import co.clai.util.cache.Cache;
import co.clai.util.cache.ExpiringCache;
import co.clai.util.cache.PermanentCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mindrot.jbcrypt.BCrypt;

public class IPSConnection
extends AbstractRemoteConnection {
    private static final String IPS_USERDATA_RETURN_KEY_ID = "id";
    private static final String IPS_USERDATA_RETURN_KEY_USERNAME = "username";
    public static final String REMOTE_TYPE_NAME = "ips";
    private static final String CONFIG_KEY_TOKEN = "token";
    private final String secureToken;
    private static final String JSON_KEY_REMOTE_PW_CHECKING = "remote_pw_checking";
    private final boolean remotePwChecking;
    private static final String JSON_KEY_COLLAB_ID = "collabId";
    private final int collabId;
    private static final String JSON_KEY_QUERY_SCRIPT_LOCATION = "queryScriptLocation";
    private final String queryScriptLocation;
    private final boolean allowPwLogin;
    private final JSONObject data;
    private final Location location;
    private final OAuth2Helper.OAuth2Data oAuth2Data;
    private final Cache<String> usernameCache;
    private final Cache<List<Integer>> userGroupCache;
    private final Cache<JSONObject> generalHttpRequestCache;

    public IPSConnection(Location location) {
        this.location = location;
        JSONObject tmpData = location == null ? null : location.getConfig();
        this.data = tmpData;
        if (tmpData == null) {
            this.collabId = -1;
            this.queryScriptLocation = null;
            this.secureToken = null;
            this.oAuth2Data = null;
            this.allowPwLogin = false;
            this.usernameCache = null;
            this.userGroupCache = null;
            this.generalHttpRequestCache = null;
            this.remotePwChecking = false;
            return;
        }
        this.oAuth2Data = OAuth2Helper.getOAuth2Data(tmpData);
        String uniqueId = tmpData.getString("uniqueId");
        if (tmpData.has(JSON_KEY_QUERY_SCRIPT_LOCATION)) {
            this.queryScriptLocation = tmpData.getString(JSON_KEY_QUERY_SCRIPT_LOCATION);
            this.secureToken = tmpData.getString(CONFIG_KEY_TOKEN);
            this.remotePwChecking = tmpData.has(JSON_KEY_REMOTE_PW_CHECKING) ? Boolean.parseBoolean(tmpData.getString(JSON_KEY_REMOTE_PW_CHECKING)) : true;
            this.collabId = tmpData.has(JSON_KEY_COLLAB_ID) ? Integer.parseInt(tmpData.getString(JSON_KEY_COLLAB_ID)) : -1;
            this.allowPwLogin = tmpData.has("allowPwLogin") ? Boolean.parseBoolean(tmpData.getString("allowPwLogin")) : true;
            this.usernameCache = null;
            this.userGroupCache = null;
            this.generalHttpRequestCache = new ExpiringCache<JSONObject>(uniqueId + "generalCache");
        } else {
            this.queryScriptLocation = null;
            this.secureToken = null;
            this.collabId = -1;
            this.allowPwLogin = false;
            this.usernameCache = new PermanentCache<String>(uniqueId + "usernameCache");
            this.userGroupCache = new PermanentCache<List<Integer>>(uniqueId + "userGroupCache");
            this.generalHttpRequestCache = null;
            this.remotePwChecking = false;
        }
    }

    @Override
    protected String getRemoteTypeName() {
        return REMOTE_TYPE_NAME;
    }

    @Override
    public JSONObject getDefaultConfig() {
        JSONObject retObj = new JSONObject();
        retObj.put("uniqueId", RandomUtil.getRandomString());
        retObj.put("type", REMOTE_TYPE_NAME);
        retObj.put(JSON_KEY_COLLAB_ID, "0");
        retObj.put(JSON_KEY_QUERY_SCRIPT_LOCATION, "http://forum.yourcommunity.com/clai_acp/ips_query.php");
        retObj.put("allowPwLogin", "false");
        retObj.put("oauth2data", OAuth2Helper.generateOAuth2ConfigSkeleton());
        return retObj;
    }

    @Override
    public RemoteUserData getUserDataByUserId(int userId) {
        if (this.queryScriptLocation == null) {
            if (this.usernameCache != null) {
                return new RemoteUserData(userId, this.usernameCache.retrieve(userId + ""), new ArrayList<Integer>(), "unknown@unknown.com");
            }
            return new RemoteUserData(userId, "Unknown User", new ArrayList<Integer>(), "unknown@unknown.com");
        }
        JSONObject userData = IPSConnection.requestCachedJSONData(this.queryScriptLocation, Arrays.asList(new StringStringPair("action", "ips_query"), new StringStringPair(CONFIG_KEY_TOKEN, this.secureToken), new StringStringPair("method", "getUserDataByUserId"), new StringStringPair("userId", userId + "")), this.generalHttpRequestCache);
        List<Integer> userGroupList = this.getUsergroupsFromUserId(userId);
        return new RemoteUserData(userId, userData.getString("name"), userGroupList, userData.getString("email"), userData.getString("members_pass_hash"), userData.getString("members_pass_salt"));
    }

    @Override
    public RemoteUserData getUserDataByUserName(String userName) {
        if (this.queryScriptLocation == null) {
            throw new RuntimeException("cannot get User data without query Script");
        }
        JSONObject userData = IPSConnection.requestCachedJSONData(this.queryScriptLocation, Arrays.asList(new StringStringPair("action", "ips_query"), new StringStringPair(CONFIG_KEY_TOKEN, this.secureToken), new StringStringPair("method", "getUserDataByUserName"), new StringStringPair("userName", userName + "")), this.generalHttpRequestCache);
        int userId = Integer.parseInt(userData.getString("member_id"));
        List<Integer> userGroupList = this.getUsergroupsFromUserId(userId);
        return new RemoteUserData(userId, userData.getString("name"), userGroupList, userData.getString("email"), userData.getString("members_pass_hash"), userData.getString("members_pass_salt"));
    }

    @Override
    public RemoteUserData getUserDataByUserEmail(String userEmail) {
        if (this.queryScriptLocation == null) {
            throw new RuntimeException("cannot get User data without query Script");
        }
        JSONObject userData = IPSConnection.requestCachedJSONData(this.queryScriptLocation, Arrays.asList(new StringStringPair("action", "ips_query"), new StringStringPair(CONFIG_KEY_TOKEN, this.secureToken), new StringStringPair("method", "getUserDataByUserEmail"), new StringStringPair("userEmail", userEmail + "")), this.generalHttpRequestCache);
        int userId = Integer.parseInt(userData.getString("member_id"));
        List<Integer> userGroupList = this.getUsergroupsFromUserId(userId);
        return new RemoteUserData(userId, userData.getString("name"), userGroupList, userData.getString("email"), userData.getString("members_pass_hash"), userData.getString("members_pass_salt"));
    }

    @Override
    public int loginUser(String username, String password) {
        if (this.remotePwChecking) {
            JSONObject userGroupsData = IPSConnection.requestCachedJSONData(this.queryScriptLocation, Arrays.asList(new StringStringPair("action", "ips_query"), new StringStringPair(CONFIG_KEY_TOKEN, this.secureToken), new StringStringPair("method", "loginUser"), new StringStringPair("userName", username), new StringStringPair("plainPass", password)), this.generalHttpRequestCache);
            if (userGroupsData.has("member_id")) {
                return Integer.parseInt(userGroupsData.getString("member_id"));
            }
            return -1;
        }
        logger.log(Level.INFO, "logging in user " + username);
        if (this.queryScriptLocation == null) {
            throw new RuntimeException("cannot login without query Script");
        }
        if (!this.allowPwLogin) {
            logger.log(Level.WARNING, "User tried to login despite being forbidden.");
            throw new RuntimeException("loginUser not allowed with this location");
        }
        RemoteUserData uData = this.getUserDataByUserName(username);
        if (uData == null) {
            uData = this.getUserDataByUserEmail(username);
        }
        if (uData == null) {
            logger.log(Level.WARNING, "User with Username " + username + " not found in Location " + this.location.getId());
            throw new RuntimeException("User not found");
        }
        String passwordHash = uData.getPasswordHash();
        logger.log(Level.INFO, passwordHash + " -->");
        String[] hashvars = passwordHash.split("\\$");
        logger.log(Level.INFO, "0: " + hashvars[0] + " 1: " + hashvars[1] + " 2: " + hashvars[2] + "  3: " + hashvars[3] + " " + uData.getPasswordSalt());
        String tempSalt = hashvars[2] + "$" + hashvars[3] + "$" + uData.getPasswordSalt();
        logger.log(Level.INFO, "--> " + tempSalt);
        String hashedProvidedPw = BCrypt.hashpw((String)password, (String)tempSalt);
        if (StringUtil.checkBytes(passwordHash.getBytes(), hashedProvidedPw.getBytes())) {
            return uData.getId();
        }
        return -1;
    }

    @Override
    public List<Integer> getUsergroupsFromUserId(int id) {
        if (this.queryScriptLocation == null) {
            if (this.usernameCache != null) {
                return this.userGroupCache.retrieve(id + "");
            }
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> retList = new ArrayList<Integer>();
        if (this.collabId >= 0) {
            JSONObject userGroupsData = IPSConnection.requestCachedJSONData(this.queryScriptLocation, Arrays.asList(new StringStringPair("action", "ips_query"), new StringStringPair(CONFIG_KEY_TOKEN, this.secureToken), new StringStringPair(JSON_KEY_COLLAB_ID, this.collabId + ""), new StringStringPair("method", "getCollabGroupsFromUserId"), new StringStringPair("userId", id + "")), this.generalHttpRequestCache);
            if (userGroupsData.has("roles")) {
                String[] rolesNumber;
                for (String s : rolesNumber = userGroupsData.getString("roles").split(",")) {
                    if ("".equals(s)) continue;
                    retList.add(new Integer(s));
                }
            } else {
                logger.log(Level.WARNING, "User with id " + id + " has no roles for collab id " + this.collabId + "; " + this.queryScriptLocation);
            }
        } else {
            String[] rolesNumber;
            JSONObject userGroupsData = IPSConnection.requestCachedJSONData(this.queryScriptLocation, Arrays.asList(new StringStringPair("action", "ips_query"), new StringStringPair(CONFIG_KEY_TOKEN, this.secureToken), new StringStringPair("method", "getUserGroupsFromUserId"), new StringStringPair("userId", id + "")), this.generalHttpRequestCache);
            retList.add(new Integer(userGroupsData.getString("member_group_id")));
            for (String s : rolesNumber = userGroupsData.getString("mgroup_others").split(",")) {
                retList.add(new Integer(s));
            }
        }
        return retList;
    }

    @Override
    public String getUsergroupNameById(int userGroupId) {
        if (this.queryScriptLocation == null) {
            try {
                return this.data.getJSONObject("usergroups").getString(userGroupId + "");
            }
            catch (Exception e) {
                throw new RuntimeException("cannot get User Group Name without query Script: " + e.getMessage());
            }
        }
        if (this.collabId >= 0) {
            JSONObject userGroupsData = IPSConnection.requestCachedJSONData(this.queryScriptLocation, Arrays.asList(new StringStringPair("action", "ips_query"), new StringStringPair(CONFIG_KEY_TOKEN, this.secureToken), new StringStringPair("method", "getCollabGroupNameById"), new StringStringPair("groupId", userGroupId + ""), new StringStringPair(JSON_KEY_COLLAB_ID, this.collabId + "")), this.generalHttpRequestCache);
            if (!userGroupsData.has("name")) {
                return "Unknown Usergroup";
            }
            return userGroupsData.getString("name");
        }
        JSONObject userGroupsData = IPSConnection.requestCachedJSONData(this.queryScriptLocation, Arrays.asList(new StringStringPair("action", "ips_query"), new StringStringPair(CONFIG_KEY_TOKEN, this.secureToken), new StringStringPair("method", "getUserGroupNameById"), new StringStringPair("groupId", userGroupId + "")), this.generalHttpRequestCache);
        if (!userGroupsData.has("word_default")) {
            return "Unknown Usergroup";
        }
        return userGroupsData.getString("word_default");
    }

    @Override
    public JSONObject getConfig() {
        return this.data;
    }

    @Override
    public boolean canDoPasswordLogin() {
        return this.allowPwLogin;
    }

    @Override
    public boolean canDoOAuth2Login() {
        return this.oAuth2Data != null;
    }

    @Override
    public OAuth2Helper.OAuth2Data getOAuth2Data() {
        return this.oAuth2Data;
    }

    @Override
    public User getUserWithOAuth2Code(DatabaseConnector dbCon, Map<String, String[]> parameters, int locationId) {
        try {
            String siteUrl = dbCon.getListener().getSiteUrl();
            String tokenRequestData = HttpRequestUtil.httpPostRequestAsString(this.oAuth2Data.accessTokenUrl, OAuth2Helper.buildTokenRequest(siteUrl, parameters.get("code")[0], this.oAuth2Data));
            logger.log(Level.INFO, tokenRequestData);
            JSONObject jTokenData = new JSONObject(tokenRequestData);
            String token = jTokenData.getString("access_token");
            String userRequestData = HttpRequestUtil.httpRequest(this.oAuth2Data.profileUrl + "?" + "access_token" + "=" + Builder.escapeForHtml(token));
            logger.log(Level.INFO, userRequestData);
            JSONObject jUserData = new JSONObject(userRequestData);
            String username = jUserData.getString(IPS_USERDATA_RETURN_KEY_USERNAME);
            int userId = jUserData.getInt(IPS_USERDATA_RETURN_KEY_ID);
            if (this.usernameCache != null) {
                this.usernameCache.put(userId + "", username);
            }
            ArrayList<Integer> usergroups = new ArrayList<Integer>();
            usergroups.add(new Integer(jUserData.getInt("group")));
            JSONArray secondaryGroups = jUserData.getJSONArray("group_others");
            for (int i = 0; i < secondaryGroups.length(); ++i) {
                String userGroup = secondaryGroups.getString(i);
                if ("".equals(userGroup)) continue;
                usergroups.add(new Integer(Integer.parseInt(userGroup)));
            }
            if (this.userGroupCache != null) {
                this.userGroupCache.put(userId + "", usergroups);
                boolean changed = false;
                Iterator iterator = usergroups.iterator();
                while (iterator.hasNext()) {
                    int uGroupId = (Integer)iterator.next();
                    if (this.data.has("usergroups") && this.data.getJSONObject("usergroups").has(uGroupId + "")) continue;
                    DummyConnection.addUserGroup(this.data, uGroupId, "unknown Group");
                    changed = true;
                }
                if (changed) {
                    this.location.changeConfig(dbCon, this.data.toString());
                }
            }
            return new User(dbCon, username, userId, locationId, Location.getLocationById(dbCon, locationId).getCommunityId(), null, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Integer> getUserIdsFromUserGroup(int userGroupId) {
        if (this.queryScriptLocation == null) {
            throw new RuntimeException("cannot get User ids from collab groups without query Script");
        }
        if (this.collabId < 0) {
            logger.log(Level.WARNING, "no collabId specified when trying to get UserField Content");
            JSONObject userGroupsData = IPSConnection.requestCachedJSONData(this.queryScriptLocation, Arrays.asList(new StringStringPair("action", "ips_query"), new StringStringPair(CONFIG_KEY_TOKEN, this.secureToken), new StringStringPair("method", "getUserIdsFromUserGroup"), new StringStringPair("groupId", userGroupId + "")), this.generalHttpRequestCache);
            ArrayList<Integer> retList = new ArrayList<Integer>();
            if (!userGroupsData.has("ids")) {
                return retList;
            }
            JSONArray userGroupArr = userGroupsData.getJSONArray("ids");
            for (int i = 0; i < userGroupArr.length(); ++i) {
                retList.add(new Integer(userGroupArr.getString(i)));
            }
            return retList;
        }
        JSONObject userGroupsData = IPSConnection.requestCachedJSONData(this.queryScriptLocation, Arrays.asList(new StringStringPair("action", "ips_query"), new StringStringPair(CONFIG_KEY_TOKEN, this.secureToken), new StringStringPair("method", "getUserIdsFromCollabGroup"), new StringStringPair("groupId", userGroupId + ""), new StringStringPair(JSON_KEY_COLLAB_ID, this.collabId + "")), this.generalHttpRequestCache);
        ArrayList<Integer> retList = new ArrayList<Integer>();
        if (!userGroupsData.has("ids")) {
            return retList;
        }
        JSONArray userGroupArr = userGroupsData.getJSONArray("ids");
        for (int i = 0; i < userGroupArr.length(); ++i) {
            retList.add(new Integer(userGroupArr.getString(i)));
        }
        return retList;
    }

    @Override
    public String getUserFieldContentFromUserId(String fieldId, int userId) {
        if (this.queryScriptLocation == null) {
            throw new RuntimeException("cannot get User Field Content without query Script");
        }
        JSONObject fieldContentData = IPSConnection.requestCachedJSONData(this.queryScriptLocation, Arrays.asList(new StringStringPair("action", "ips_query"), new StringStringPair(CONFIG_KEY_TOKEN, this.secureToken), new StringStringPair("method", "getUserFieldContentFromUserId"), new StringStringPair("userId", userId + ""), new StringStringPair("fieldId", fieldId)), this.generalHttpRequestCache);
        if (!fieldContentData.has(fieldId) || fieldContentData.isNull(fieldId)) {
            return null;
        }
        return fieldContentData.getString(fieldId);
    }
}

