/*
 * Decompiled with CFR 0.152.
 */
package co.clai.remote;

import co.clai.db.DatabaseConnector;
import co.clai.db.model.Location;
import co.clai.db.model.User;
import co.clai.html.Builder;
import co.clai.remote.AbstractRemoteConnection;
import co.clai.remote.OAuth2Helper;
import co.clai.remote.RemoteUserData;
import co.clai.util.HttpRequestUtil;
import co.clai.util.RandomUtil;
import co.clai.util.StringStringPair;
import co.clai.util.cache.Cache;
import co.clai.util.cache.ExpiringCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.json.JSONArray;
import org.json.JSONObject;

public class XenforoConnection
extends AbstractRemoteConnection {
    public static final String REMOTE_TYPE_NAME = "xenforo";
    private static final String JSON_KEY_REMOTE_PW_CHECKING = "remote_pw_checking";
    private final boolean remotePwChecking;
    private static final String CONFIG_KEY_REMOTESCRIPT = "remote";
    private final String remoteScript;
    private static final String CONFIG_KEY_TOKEN = "token";
    private final String secureToken;
    private final boolean allowPwLogin;
    private final OAuth2Helper.OAuth2Data oAuth2Data;
    private final Cache<JSONObject> generalHttpRequestCache;
    private final JSONObject data;

    public XenforoConnection(Location l) {
        this.data = l == null ? null : l.getConfig();
        if (this.data == null) {
            this.remoteScript = null;
            this.secureToken = null;
            this.allowPwLogin = false;
            this.oAuth2Data = null;
            this.generalHttpRequestCache = null;
            this.remotePwChecking = false;
            return;
        }
        this.remotePwChecking = this.data.has(JSON_KEY_REMOTE_PW_CHECKING) ? Boolean.parseBoolean(this.data.getString(JSON_KEY_REMOTE_PW_CHECKING)) : true;
        this.allowPwLogin = this.data.has("allowPwLogin") ? Boolean.parseBoolean(this.data.getString("allowPwLogin")) : true;
        this.remoteScript = this.data.getString(CONFIG_KEY_REMOTESCRIPT);
        this.secureToken = this.data.has(CONFIG_KEY_TOKEN) ? this.data.getString(CONFIG_KEY_TOKEN) : null;
        this.oAuth2Data = OAuth2Helper.getOAuth2Data(this.data);
        String uniqueId = this.data.getString("uniqueId");
        this.generalHttpRequestCache = new ExpiringCache<JSONObject>(uniqueId + "generalCache");
    }

    @Override
    protected String getRemoteTypeName() {
        return REMOTE_TYPE_NAME;
    }

    @Override
    public JSONObject getDefaultConfig() {
        JSONObject retObj = new JSONObject();
        retObj.put("uniqueId", RandomUtil.getRandomString());
        retObj.put("type", REMOTE_TYPE_NAME);
        retObj.put(CONFIG_KEY_REMOTESCRIPT, "http://forum.yourcommunity.com/xf_query.php");
        retObj.put("allowPwLogin", "false");
        retObj.put(CONFIG_KEY_TOKEN, "secret token here");
        retObj.put("oauth2data", OAuth2Helper.generateOAuth2ConfigSkeleton());
        return retObj;
    }

    @Override
    public RemoteUserData getUserDataByUserId(int userId) {
        JSONObject userData = XenforoConnection.requestCachedJSONData(this.remoteScript, Arrays.asList(new StringStringPair("action", "ips_query"), new StringStringPair(CONFIG_KEY_TOKEN, this.secureToken), new StringStringPair("method", "getUserDataByUserId"), new StringStringPair("userId", userId + "")), this.generalHttpRequestCache);
        List<Integer> userGroupList = this.getUsergroupsFromUserId(userId);
        return new RemoteUserData(userId, userData.getString("username"), userGroupList, userData.getString("email"), "", "");
    }

    @Override
    public int loginUser(String username, String password) {
        logger.log(Level.WARNING, "login user not yet implemented in XenforoConnection");
        return 0;
    }

    @Override
    public List<Integer> getUsergroupsFromUserId(int id) {
        ArrayList<Integer> retList = new ArrayList<Integer>();
        JSONObject userGroupsData = XenforoConnection.requestCachedJSONData(this.remoteScript, Arrays.asList(new StringStringPair("action", "ips_query"), new StringStringPair(CONFIG_KEY_TOKEN, this.secureToken), new StringStringPair("method", "getUserGroupsFromUserId"), new StringStringPair("userId", id + "")), this.generalHttpRequestCache);
        if (!userGroupsData.has("ids")) {
            return retList;
        }
        JSONArray userGroupArr = userGroupsData.getJSONArray("ids");
        for (int i = 0; i < userGroupArr.length(); ++i) {
            retList.add(new Integer(userGroupArr.getString(i)));
        }
        return retList;
    }

    @Override
    public RemoteUserData getUserDataByUserName(String userName) {
        JSONObject userData = XenforoConnection.requestCachedJSONData(this.remoteScript, Arrays.asList(new StringStringPair("action", "ips_query"), new StringStringPair(CONFIG_KEY_TOKEN, this.secureToken), new StringStringPair("method", "getUserDataByUserName"), new StringStringPair("userName", userName)), this.generalHttpRequestCache);
        int userId = Integer.parseInt(userData.getString("id"));
        List<Integer> userGroupList = this.getUsergroupsFromUserId(userId);
        return new RemoteUserData(userId, userData.getString("name"), userGroupList, userData.getString("email"), "", "");
    }

    @Override
    public String getUsergroupNameById(int userGroupId) {
        JSONObject userGroupsData = XenforoConnection.requestCachedJSONData(this.remoteScript, Arrays.asList(new StringStringPair("action", "ips_query"), new StringStringPair(CONFIG_KEY_TOKEN, this.secureToken), new StringStringPair("method", "getUserGroupNameById"), new StringStringPair("groupId", userGroupId + "")), this.generalHttpRequestCache);
        if (!userGroupsData.has("title")) {
            return "Unknown Usergroup";
        }
        return userGroupsData.getString("title");
    }

    @Override
    public JSONObject getConfig() {
        return this.data;
    }

    @Override
    public boolean canDoPasswordLogin() {
        return this.allowPwLogin;
    }

    @Override
    public boolean canDoOAuth2Login() {
        return this.oAuth2Data != null;
    }

    @Override
    public OAuth2Helper.OAuth2Data getOAuth2Data() {
        return this.oAuth2Data;
    }

    @Override
    public User getUserWithOAuth2Code(DatabaseConnector dbCon, Map<String, String[]> parameters, int locationId) {
        try {
            String siteUrl = dbCon.getListener().getSiteUrl();
            logger.log(Level.INFO, this.oAuth2Data.accessTokenUrl.toString());
            Map<String, String> buildTokenRequest = OAuth2Helper.buildTokenRequest(siteUrl, parameters.get("code")[0], this.oAuth2Data);
            logger.log(Level.INFO, buildTokenRequest.toString());
            String tokenRequestData = HttpRequestUtil.httpPostRequestAsString(this.oAuth2Data.accessTokenUrl, buildTokenRequest);
            logger.log(Level.INFO, tokenRequestData);
            JSONObject jTokenData = new JSONObject(tokenRequestData);
            String token = jTokenData.getString("access_token");
            int userId = jTokenData.getInt("user_id");
            String userRequestData = HttpRequestUtil.httpRequest(this.oAuth2Data.profileUrl + "?users/:" + userId + "access_token" + "=" + Builder.escapeForHtml(token));
            logger.log(Level.INFO, userRequestData);
            JSONObject jUserData = new JSONObject(userRequestData);
            if (!jUserData.has("links")) {
                return null;
            }
            RemoteUserData userdata = this.getUserDataByUserId(userId);
            return new User(dbCon, userdata.getUsername(), userId, locationId, Location.getLocationById(dbCon, locationId).getCommunityId(), null, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RemoteUserData getUserDataByUserEmail(String userEmail) {
        JSONObject userData = XenforoConnection.requestCachedJSONData(this.remoteScript, Arrays.asList(new StringStringPair("action", "ips_query"), new StringStringPair(CONFIG_KEY_TOKEN, this.secureToken), new StringStringPair("method", "getUserDataByUserName"), new StringStringPair("userEmail", userEmail)), this.generalHttpRequestCache);
        int userId = Integer.parseInt(userData.getString("id"));
        List<Integer> userGroupList = this.getUsergroupsFromUserId(userId);
        return new RemoteUserData(userId, userData.getString("name"), userGroupList, userData.getString("email"), "", "");
    }

    @Override
    public List<Integer> getUserIdsFromUserGroup(int userGroupId) {
        JSONObject userGroupsData = XenforoConnection.requestCachedJSONData(this.remoteScript, Arrays.asList(new StringStringPair("action", "ips_query"), new StringStringPair(CONFIG_KEY_TOKEN, this.secureToken), new StringStringPair("method", "getUserIdsFromUserGroup"), new StringStringPair("groupId", userGroupId + "")), this.generalHttpRequestCache);
        ArrayList<Integer> retList = new ArrayList<Integer>();
        if (!userGroupsData.has("ids")) {
            return retList;
        }
        JSONArray userGroupArr = userGroupsData.getJSONArray("ids");
        for (int i = 0; i < userGroupArr.length(); ++i) {
            retList.add(new Integer(userGroupArr.getString(i)));
        }
        return retList;
    }

    @Override
    public String getUserFieldContentFromUserId(String fieldId, int userId) {
        JSONObject fieldContentData = XenforoConnection.requestCachedJSONData(this.remoteScript, Arrays.asList(new StringStringPair("action", "ips_query"), new StringStringPair(CONFIG_KEY_TOKEN, this.secureToken), new StringStringPair("method", "getUserFieldContentFromUserId"), new StringStringPair("userId", userId + ""), new StringStringPair("fieldId", fieldId)), this.generalHttpRequestCache);
        if (!fieldContentData.has("field_value") || fieldContentData.isNull("field_value")) {
            return null;
        }
        return fieldContentData.getString("field_value");
    }
}

